#include "npconfig.h"

void address_buttons_callback( GtkWidget *widget, gpointer data )
{
   NP_Config *config =
      ( NP_Config *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                         "config" );

   GtkWidget *clist =
      ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                         "clist" );
   
   int i;
   if (( i = config->subscription[ ( const char *)data ] ) < 0 )
   {
      config->subscription.print_error();
      return;
   }
   
   config->current_server = i;

   int total = config->subscription.get_total_groups( i );
   if ( total < 0 )
   {
      config->subscription.print_error();
      return;
   }

   gtk_clist_clear( GTK_CLIST( clist ));
   gtk_clist_freeze( GTK_CLIST( clist ));

   char buffer[ 256 ];
   snprintf( buffer, sizeof buffer, "%d Subscribed Newsgroups", total );
   gtk_clist_set_column_title( GTK_CLIST( clist ), 0, buffer );
   
   config->group_clist_lines = 0;

   if ( total )
      for( int j = 0; j < total; ++j )
      {
         char *lines[ 2 ];
         if (( lines[ 0 ] = ( char *)config->subscription.get_group( i, j ))
             == NULL )
         {
            config->subscription.print_error();
            return;
         }

         if (( lines[ 1 ] =
               ( char *)config->subscription.get_article_no( i, j ))
             == NULL )
         {
            config->subscription.print_error();
            return;
         }
      
         gtk_clist_append( GTK_CLIST( clist ), lines );
         ++config->group_clist_lines;
      }

   gtk_clist_thaw( GTK_CLIST( clist ));
   
   return;
}
