#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>

#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void pack_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( collections->search_shown )
      gtk_clist_clear( GTK_CLIST( collections->search_clist ));

   if ( collections->callbacks_disabled )
      return;

   if ( !collections->total_nodes )
      return;

   char *server = NULL, *group = NULL;

   if ( collections->selected_item != NULL )
   {
      server = ( char *)gtk_object_get_data(
         GTK_OBJECT( collections->selected_item ), "server" );

      group = ( char *)gtk_object_get_data(
         GTK_OBJECT( collections->selected_item ), "group" );
   }

   char *what = NULL, *message, *program = "npsepax", quantity[ 8 ];
   int clear_summary = 0;
   
   switch( ( int )widget )
   {
   case ( int )NULL:
      what = "--expire";
      message = "Expiring";
      clear_summary = 1;
      break;

   case 1:
      what = "--search";
      message = "Searching";
      if ( collections->search_results.clear())
      {
         collections->search_results.print_error();
         return;
      }
      clear_summary = 0;
      break;

   case 2:
      switch( collections->transfer_what )
      {
      case 0:
         what = "headers";
         break;

      case 1:
         what = "articles";
         break;

      case 2:
         what = "requests";
         break;
      }
      
      clear_summary = 1;
      message = "Transferring";
      program = "nptransfer";
      snprintf( quantity, sizeof quantity, "%d",
                collections->transfer_quantity );
      break;
      
   default:
      what = "--pack";
      clear_summary = 1;
      message = "Packing";
      break;
   }

   if ( clear_summary && collections->summary_pid )
      kill( collections->summary_pid, SIGUSR2 );
   
   int outpipe_fds[ 2 ];
   if ( pipe( outpipe_fds ))
   {
      perror( "pipe" );
      return;
   }

   int inpipe_fds[ 2 ];
   if ( pipe( inpipe_fds ))
   {
      close( outpipe_fds[ 0 ] );
      close( outpipe_fds[ 1 ] );
      perror( "pipe" );
      return;
   }

   int errpipe_fds[ 2 ];
   if ( pipe( errpipe_fds ))
   {
      close( outpipe_fds[ 0 ] );
      close( outpipe_fds[ 1 ] );
      close( inpipe_fds[ 0 ] );
      close( inpipe_fds[ 1 ] );
      perror( "pipe" );
      return;
   }

   char *regexp = NULL;
   if ( what[ 2 ] == 's' )
      regexp = ( char *)gtk_object_get_data( GTK_OBJECT( collections->window ),
                                             "regexp" );

   switch( collections->child_pid = fork() )
   {
   case -1:
      perror( "fork" );
      close( outpipe_fds[ 0 ] );
      close( outpipe_fds[ 1 ] );
      close( inpipe_fds[ 0 ] );
      close( inpipe_fds[ 1 ] );
      close( errpipe_fds[ 0 ] );
      close( errpipe_fds[ 1 ] );

      return;
      break;

   case 0:
      close( ConnectionNumber( gdk_display ));
      close( outpipe_fds[ 1 ] );
      close( inpipe_fds[ 0 ] );
      close( errpipe_fds[ 0 ] );
      
      if ( dup2( outpipe_fds[ 0 ], STDIN_FILENO ) < 0 )
      {
         perror( "dup2" );
         _exit( 1 );
      }

      if ( dup2( inpipe_fds[ 1 ], STDOUT_FILENO ) < 0 )
      {
         perror( "dup2" );
         _exit( 1 );
      }

      if ( dup2( errpipe_fds[ 1 ], STDERR_FILENO ) < 0 )
      {
         perror( "dup2" );
         _exit( 1 );
      }

      if ( ( int )widget == 2 )
         execlp( program, program, "--type", what, "--quantity", quantity,
                 NULL );
      else
         execlp( program, program, what, regexp, NULL );

      perror( "execlp" );
      _exit( 1 );
      break;

   default:
      close( outpipe_fds[ 0 ] );
      close( inpipe_fds[ 1 ] );
      close( errpipe_fds[ 1 ] );

      int result = 0;
      char buffer[ 128 ];
      snprintf( buffer, sizeof buffer, "%d", collections->child_pid );

      if ( collections->child_pid )
         while(( result = collections->children.add_item( buffer )) == 3 );

      if ( result )
      {
         collections->children.print_error();
         close( outpipe_fds[ 0 ] );
         close( outpipe_fds[ 1 ] );
         close( inpipe_fds[ 0 ] );
         close( inpipe_fds[ 1 ] );

         return;
      }
      break;
   }

   FILE *in_file;
   if (( in_file = fdopen( inpipe_fds[ 0 ], "r" )) == NULL )
   {
      perror( "fdopen" );
      close( outpipe_fds[ 1 ] );
      close( inpipe_fds[ 0 ] );
      close( errpipe_fds[ 0 ] );

      return;
   }

   FILE *err_file;
   if (( err_file = fdopen( errpipe_fds[ 0 ], "r" )) == NULL )
   {
      perror( "fdopen" );
      fclose( in_file );
      close( outpipe_fds[ 1 ] );
      close( errpipe_fds[ 0 ] );

      return;
   }

   FILE *out_file;
   if (( out_file = fdopen( outpipe_fds[ 1 ], "w" )) == NULL )
   {
      perror( "fdopen" );
      fclose( in_file );
      fclose( err_file );
      close( outpipe_fds[ 1 ] );

      return;
   }

   NP_Stringarray output_lines;

   if ( server == NULL )
   {
      if ( collections->do_all_servers( out_file, output_lines ))
      {
         fclose( in_file );
         fclose( out_file );
         fclose( err_file );

         return;
      }
   }
   else
      if ( server != NULL && group == NULL )
      {
         if ( collections->do_one_server( server, out_file, output_lines ))
         {
            fclose( in_file );
            fclose( out_file );
            fclose( err_file );

            return;
         }
      }
      else
         if ( server != NULL && group != NULL )
         {
            char buffer[ 1024 ];
            snprintf( buffer, sizeof buffer, "%s:%s\n", server, group );
            if ( fputs( buffer, out_file ) < 0 )
            {
               fclose( in_file );
               fclose( out_file );
               fclose( err_file );

               return;
            }

            snprintf( buffer, sizeof buffer, "%s: %s...", server, group );
            if ( output_lines.add_item( buffer ))
            {
               collections->show_message( output_lines.get_error(), 0 );
               fclose( in_file );
               fclose( out_file );
               fclose( err_file );

               return;
            }
         }

   collections->disable_callbacks( collections->window, 1 );
   
   fclose( out_file );

   int total_lines = output_lines.get_total();
   if ( total_lines < 0 )
      output_lines.print_error();

   int i = 0;
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s...", message );
   if ( group == NULL )
   {
      if ( ( int)widget == 2 )
         collections->show_message( buffer, 2 );
      else
         collections->show_message( buffer, 3 );
   }
   else
      collections->show_message( buffer, 3 );

   collections->stop = 0;

   NP_Stringarray error_messages, transfer_results;

   int error = 0;

   collections->update_message( ( char *)output_lines[ i ] );

   while( !feof( in_file ))
   {
      int result, num_fds;
      fd_set rset;
      struct timeval tval;

      do
      {
         while( gtk_events_pending() > 0 )
            gtk_main_iteration();

         if ( collections->stop )
            break;

         FD_ZERO( &rset );
         FD_SET( inpipe_fds[ 0 ], &rset );
         if ( !feof( err_file ))
            FD_SET( errpipe_fds[ 0 ], &rset );

         num_fds = (( inpipe_fds[ 0 ] > errpipe_fds[ 0 ] ) ? inpipe_fds[ 0 ] :
                    errpipe_fds[ 0 ] ) + 1;

         tval.tv_sec = 0;
         tval.tv_usec = 250000;
      }
      while( !( result = select( num_fds, &rset, NULL, NULL, &tval )));

      if ( collections->stop )
         break;

      if ( result < 0 )
      {
         if ( errno == EINTR )
            continue;

         perror( "select" );
         break;
      }

      if ( !feof( err_file ))
         if ( FD_ISSET( errpipe_fds[ 0 ], &rset ))   
         {
            *buffer = '\0';
            fgets( buffer, sizeof buffer, err_file );

            if ( *buffer != '\0' )
            {
               error = 1;
               if ( error_messages.add_item( buffer ))
                  error_messages.print_error();
            }

            if ( strstr( buffer, "400" ) || strchr( buffer, '5' ))
               collections->stop = 1;
         }

      if ( FD_ISSET( inpipe_fds[ 0 ], &rset ))
      {
         if ( fgets( buffer, sizeof buffer, in_file ) == NULL )
            break;

         if ( ( int)widget == 1 )
         {
            if ( collections->search_results.add_item( buffer ))
               collections->search_results.print_error();
            continue;
         }

         if ( ( int)widget == 2 )
         {
            if ( ++i >= total_lines && total_lines > 1 )
                 break;

            if ( group == NULL )
               gtk_progress_bar_update(
                  GTK_PROGRESS_BAR( collections->message_progress_bar ),
                  ( float)i / total_lines );

            char *pointer;

            if ( total_lines > 1 )
            {
               pointer = ( char *)output_lines[ i ];
               if ( pointer == NULL )
               {
                  fclose( in_file );
                  fclose( err_file );
                  message_callback( collections->message_button, data );
                  collections->show_message( output_lines.get_error(), 0 );
                  collections->disable_callbacks( collections->window, 0 );
                  return;
               }

               collections->update_message( pointer );
            }

            pointer = ( char *)output_lines[ i - 1 ];

            char second_buffer[ 1024 ];
            *( strrchr( pointer, '.' ) - 2 ) = '\0';
            snprintf( second_buffer, sizeof second_buffer,
                      "%s: %s: %s", message, pointer, buffer );

            if ( transfer_results.add_item( second_buffer ))
               transfer_results.print_error();
         }
      }
   }

   if ( collections->stop )
      if ( collections->child_pid )
         kill( collections->child_pid, SIGTERM );

   fclose( in_file );
   fclose( err_file );

   collections->disable_callbacks( collections->window, 0 );
   message_callback( collections->message_button, data );

   if ( error )
   {
      int total = error_messages.get_total();

      if ( total < 0 )
         error_messages.print_error();
      else
      {
         int count = 0;
         char *line;
         for( int i = 0; i < total; ++i )
         {
            if (( line = ( char *)error_messages[ i ] ) == NULL )
            {
               error_messages.print_error();
               break;
            }

            count += strlen( line );
         }

         if (( line = ( char *)malloc( count + 30 )) == NULL )
         {
            perror( "malloc" );
            exit( 1 );
         }

         strcpy( line, "NPTRANSFER ERROR MESSAGES:\n\n" );
         for( int i = 0; i < total; ++i )
            strcat( line, error_messages[ i ] );

         collections->show_message( line, 0 );

         while( collections->message_window != NULL )
            while( gtk_events_pending())
               gtk_main_iteration();
      }
   }

   if ( ( int)widget == 2 )
   {
      int total = transfer_results.get_total();

      if ( total < 0 )
         transfer_results.print_error();
      else
      {
         int count = 0;
         char *line;
         for( int i = 0; i < total; ++i )
         {
            if (( line = ( char *)transfer_results[ i ] ) == NULL )
            {
               transfer_results.print_error();
               return;
            }

            char *pointer = strchr( line, ':' );
            pointer += 2;

            pointer = strchr( pointer, ':' );
            pointer += 2;
            if ( !strncmp( pointer, "POSTED", 6 ) ||
                 !strncmp( pointer, "SENT-MAIL", 9 ))
               continue;

            count += strlen( line );
         }

         if (( line = ( char *)malloc( count + 25 )) == NULL )
         {
            perror( "malloc" );
            exit( 1 );
         }

         strcpy( line, "NPTRANSFER RESULTS:\n\n" );
         for( int i = 0; i < total; ++i )
         {
            char *original = ( char *)transfer_results[ i ];
            if ( original == NULL )
            {
               transfer_results.print_error();
               return;
            }

            char *pointer = strchr( original, ':' );
            pointer += 2;

            pointer = strchr( pointer, ':' );
            pointer += 2;
            if ( !strncmp( pointer, "POSTED", 6 ) ||
                 !strncmp( pointer, "SENT-MAIL", 9 ))
               continue;

            strcat( line, original );
         }

         collections->show_message( line, 0 );

         while( collections->message_window != NULL )
            while( gtk_events_pending())
               gtk_main_iteration();
      }
   }

   if ( ( int)widget != 1 )
   {
      collections->search_position = -2;
      collections->update_tree();
      collections->search_position = -1;
   }

   return;
}
