#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void NP_Collections::fork_browser()
{
   char buffer[ 1024 ];
   NP_File config;

   snprintf( buffer, sizeof buffer, "%s/.peruser4-config", getenv( "HOME" ));
   if ( config.openr( buffer ))
   {
      config.print_error();
      return;
   }

   char *browser = NULL;
   int i = 3;
   while( i-- )
   {
      if (( browser = config.get_string()) == NULL )
      {
         config.print_error();
         config.close();
         return;
      }
   }

   if ( strtok( browser, "\n" ) == NULL )
      return;

   int running = 0;
   if ( strstr( browser, "netscape" ) != NULL )
   {
      FILE *file;
      if (( file = popen( "ps aux", "r" )) == NULL )
      {
         perror( "popen" );
         return;
      }

      while( fgets( buffer, sizeof buffer, file ) != NULL )
         if ( strstr( buffer, "netscape" ))
         {
            running = 1;
            break;
         }

      pclose( file );

      if ( running )
         switch( fork() )
         {
            case -1:
               perror( "fork" );
               break;

            case 0:
               close( ConnectionNumber( gdk_display ));
               execlp( browser, browser, 
                     "-remote", "openURL(http://peruser.netpedia.net)", 
                     "-raise", NULL );
               perror( "execlp" );
               _exit( 1 );
               break;

            default:
               break;
         }
      else
         switch( fork() )
         {
            case -1:
               perror( "fork" );
               break;

            case 0:
               close( ConnectionNumber( gdk_display ));
               execlp( browser, browser, "http://peruser.netpedia.net", NULL );
               perror( "execlp" );
               _exit( 1 );
               break;
         }
   }

   config.close();

   return;
}
