/********************************
 Add messages to histories
 (c) 1999 Jeremy Wise 
 GnomeICU 
*********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <gtk/gtk.h>

/*** Global functions ***/
void add_incoming_to_history( int uin, char *statement )
{
	time_t timedate;
	struct tm *my_tm;
	gchar *pdate = NULL;
	int cx, cy, cz;
	char *halves[] = { "AM", "PM" };
	int half = 0;

	gchar *filename;
	int file;

#ifdef TRACE_FUNCTION
	g_print( "add_incoming_to_history\n" );
#endif

	time( &timedate );
	my_tm = localtime( &timedate );

	if( my_tm->tm_hour > 12 )
	{
		my_tm->tm_hour -= 12 ;
		half ++;
	}

	filename = g_strdup_printf( "/%s/.icq/history/%d", getenv( "HOME" ), uin);
	if( ( file = open( filename, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR | S_IWUSR ) ) == -1 )
	  {
	    g_warning("gnomeicu:open:%s:%s\n", filename, g_strerror(errno));
	    return;
	  }

	g_free( filename );

	pdate = g_strdup_printf( "\n*** %02d/%02d/%d %02d:%02d:%02d %s [ Received ] ***\n",
				 my_tm->tm_mon + 1, 
				 my_tm->tm_mday,
				 my_tm->tm_year + 1900,
				 my_tm->tm_hour,
				 my_tm->tm_min,
				 my_tm->tm_sec,
				 halves[ half ] );

	write( file, pdate, strlen( pdate ) );

	g_free( pdate );

	cy = cz = 0;
	for( cx = 0; cx < strlen( statement ); cx ++ )
	{
		cy ++;
		if( statement[cx] == '\n' || cy == 70 ||
		    ( cy >= 60 && statement[cx] == ' ' ) )
		{
			write( file, ( statement + cz ), cy );
			if( cy >= 60 && cy != 70 )
			{
				write( file, "\n", 1 );
			}
			if( cy == 70 )
			{
				write( file, "-\n", 2 );
			}
			cz += cy;
			cy = 0;
		}
	}			

	if( cz != strlen( statement ) )
	{
		write( file, ( statement + cz ), strlen( statement ) - cz );
	}

	write( file, "\n", 1 );

	close( file );
}

void add_outgoing_to_history( int uin, char *statement )
{
	time_t timedate;
	struct tm *my_tm;
	gchar *pdate = NULL;
	int cx, cy, cz;
	char *halves[] = { "AM", "PM" };
	int half = 0;

	gchar *filename;
	int file;

#ifdef TRACE_FUNCTION
	g_print( "add_outgoing_to_history\n" );
#endif

	time( &timedate );
	my_tm = localtime( &timedate );

	if( my_tm->tm_hour > 12 )
	{
		my_tm->tm_hour -= 12 ;
		half ++;
	}


	filename = g_strdup_printf( "/%s/.icq/history/%d", getenv( "HOME" ), uin);

	if( ( file = open( filename, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR | S_IWUSR ) ) == -1 )
	  {
	    g_warning("gnomeicu:open:%s:%s\n", filename, g_strerror(errno));
	    return;
	  }

	g_free( filename );

	pdate = g_strdup_printf( "\n*** %02d/%02d/%d %02d:%02d:%02d %s [ Sent ] ***\n",
				 my_tm->tm_mon + 1,
				 my_tm->tm_mday,
				 my_tm->tm_year + 1900,
				 my_tm->tm_hour,
				 my_tm->tm_min,
				 my_tm->tm_sec,
				 halves[ half ] );

	write( file, pdate, strlen( pdate ) );

	g_free( pdate );

	cy = cz = 0;
	for( cx = 0; cx < strlen( statement ); cx ++ )
	{
		cy ++;
		if( statement[cx] == '\n' || cy == 70 ||
		    ( cy >= 60 && statement[cx] == ' ' ) )
		{
			write( file, ( statement + cz ), cy );
			if( cy >= 60 && cy != 70 )
			{
				write( file, "\n", 1 );
			}
			if( cy == 70 )
			{
				write( file, "-\n", 2 );
			}
			cz += cy;
			cy = 0;
		}
	}			

	if( cz != strlen( statement ) )
	{
		write( file, ( statement + cz ), strlen( statement ) - cz );
	}
	
	write( file, "\n", 1 );

	close( file );
}
