/**************************
 Handle file transfer
 (c) 1999 Jeremy Wise
 GnomeICU
***************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Global functions ***/
filexferdlg *create_file_xfer_dialog( char *curfile, int numfiles,
                                      int curbytes, int bbytes )
{
	filexferdlg *dlg = g_new0( filexferdlg, 1 );
	GtkWidget *table;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *frame;
	GtkWidget *label;
	char string[16];

	if( dlg == NULL )
		return NULL;

	dlg->cf_starttime = 0;
	dlg->b_starttime = 0;
	dlg->cf_bytes_sent = 0;
	dlg->b_bytes_sent = 0;
	dlg->cf_totbytes = curbytes;
	dlg->b_totbytes = bbytes;
	dlg->b_totfiles = numfiles;
	
	dlg->window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title( GTK_WINDOW( dlg->window ), _("GnomeICU: File Transfer") );
	gtk_container_set_border_width( GTK_CONTAINER( dlg->window ), 10 );

	table = gtk_table_new( 4, 2, FALSE );
	gtk_container_add( GTK_CONTAINER( dlg->window ), table );
	
	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Current File:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	sprintf( string, "1/%d", numfiles );

	dlg->tot_files = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( dlg->tot_files ), string );
	gtk_widget_set_usize( dlg->tot_files, 50, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->tot_files, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->tot_files );

	dlg->current_file = gtk_entry_new();
	gtk_widget_set_usize( dlg->current_file, 137, 0 );
	gtk_entry_set_text( GTK_ENTRY( dlg->current_file ), curfile );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->current_file, TRUE, TRUE, 0 );
	gtk_widget_show( dlg->current_file );

	gtk_table_attach_defaults( GTK_TABLE( table ), hbox, 0, 2, 0, 1 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Local File Name:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->local_filename = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( dlg->local_filename ), _("Not Available") );
	gtk_box_pack_start( GTK_BOX( hbox ), dlg->local_filename, TRUE, TRUE, 0 );
	gtk_widget_show( dlg->local_filename );

	gtk_table_attach_defaults( GTK_TABLE( table ), hbox, 0, 2, 1, 2 );
	gtk_widget_show( hbox );

	frame = gtk_frame_new( _("Current File") );
	gtk_widget_set_usize( frame, 200, 0 );
	gtk_container_set_border_width( GTK_CONTAINER( frame ), 7 );
	vbox = gtk_vbox_new( TRUE, 0 );
	gtk_container_set_border_width( GTK_CONTAINER( vbox ), 7 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_table_attach_defaults( GTK_TABLE( table ), frame, 0, 1, 2, 3 );
	gtk_widget_show( frame );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Size:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	sprintf( string, "%d", curbytes );

	dlg->cf_size = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( dlg->cf_size ), string );
	gtk_widget_set_usize( dlg->cf_size, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->cf_size, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_size );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Trans:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->cf_trans = gtk_entry_new();
	gtk_widget_set_usize( dlg->cf_trans, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->cf_trans, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_trans );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Time:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->cf_time = gtk_entry_new();
	gtk_widget_set_usize( dlg->cf_time, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->cf_time, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_time );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("BPS:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->cf_bps = gtk_entry_new();
	gtk_widget_set_usize( dlg->cf_bps, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->cf_bps, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_bps );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("ETA:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->cf_eta = gtk_entry_new();
	gtk_widget_set_usize( dlg->cf_eta, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->cf_eta, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_eta );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	dlg->cf_progress = gtk_progress_bar_new();
	gtk_box_pack_start( GTK_BOX( vbox ), dlg->cf_progress, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->cf_progress );

	gtk_widget_show( vbox );

	frame = gtk_frame_new( _("Batch") );
	gtk_widget_set_usize( frame, 200, 0 );
	gtk_container_set_border_width( GTK_CONTAINER( frame ), 7 );
	vbox = gtk_vbox_new( TRUE, 0 );
	gtk_container_set_border_width( GTK_CONTAINER( vbox ), 7 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_table_attach_defaults( GTK_TABLE( table ), frame, 1, 2, 2, 3 );
	gtk_widget_show( frame );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Size:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	sprintf( string, "%d", bbytes );

	dlg->b_size = gtk_entry_new();
	gtk_entry_set_text( GTK_ENTRY( dlg->b_size ), string );
	gtk_widget_set_usize( dlg->b_size, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->b_size, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_size );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Trans:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->b_trans = gtk_entry_new();
	gtk_widget_set_usize( dlg->b_trans, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->b_trans, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_trans );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("Time:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->b_time = gtk_entry_new();
	gtk_widget_set_usize( dlg->b_time, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->b_time, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_time );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("BPS:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->b_bps = gtk_entry_new();
	gtk_widget_set_usize( dlg->b_bps, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->b_bps, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_bps );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	hbox = gtk_hbox_new( FALSE, 0 );

	label = gtk_label_new( _("ETA:") );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );

	dlg->b_eta = gtk_entry_new();
	gtk_widget_set_usize( dlg->b_eta, 100, 0 );
	gtk_box_pack_end( GTK_BOX( hbox ), dlg->b_eta, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_eta );

	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	dlg->b_progress = gtk_progress_bar_new();
	gtk_box_pack_start( GTK_BOX( vbox ), dlg->b_progress, FALSE, FALSE, 0 );
	gtk_widget_show( dlg->b_progress );

	gtk_widget_show( vbox );

	dlg->cancel = gtk_button_new_with_label( _("Cancel") );
	gtk_table_attach_defaults( GTK_TABLE( table ), dlg->cancel, 0, 2, 3, 4 );
	gtk_widget_show( dlg->cancel );

	gtk_widget_show( table );
	gtk_widget_show( dlg->window );

	return dlg;
}
