/*
 dial.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gmasqdialer.h"

static gint checktag;
static time_t checktime;

static void callback_dialstatus(CALLBACK_DATA *data)
{
    animation_stop();
    if (data->u.connection.connection == NULL)
        set_dial_sensitive(TRUE, FALSE);
    else
    {
	/* connected */
#ifdef HAVE_GNOME_PANEL
	if (applet_running && hide_mainwin_after_connect)
	{
	    /* hide main window */
	    applet_hidemain();
	}
#endif
        g_free(data->u.connection.connection);
        set_dial_sensitive(FALSE, TRUE);
    }
}

static gint check_dialstat(void)
{
    if (ready && checktime+2 < time(NULL))
    {
	/* wait a couple of seconds so STAT returns right.. */
	mserver_status(callback_dialstatus);
	gtk_timeout_remove(checktag);
        return 0;
    }
    return 1;
}

static void callback_dial(CALLBACK_DATA *data)
{
    if (data->status == 0) return;

    switch (data->u.list.type)
    {
	case LIST_END:
	    checktime = time(NULL);
            checktag = gtk_timeout_add(500, (GtkFunction) check_dialstat, NULL);
            break;
        case LIST_ITEM:
            gtk_statusbar_pop(GTK_STATUSBAR(statusbar), 1);
            gtk_statusbar_push(GTK_STATUSBAR(statusbar), 1, data->u.list.data);
            break;
    }
}

void menu_dial(void)
{
    gchar *isp;

    if (!mserver_connected()) return;

    if (GTK_LIST(GTK_COMBO(combo)->list)->selection == NULL)
    {
        masqerror(_("You haven't selected any connection"));
        return;
    }

    isp = gtk_object_get_data(GTK_OBJECT(GTK_LIST(GTK_COMBO(combo)->list)->selection->data), "name");
    set_dial_sensitive(FALSE, FALSE);
    mserver_dial(isp, callback_dial);

    /* change the default isp */
    g_free(defaultisp);
    defaultisp = g_strdup(isp);
    gnome_config_set_string("/"PACKAGE"/host/isp", isp);
    gnome_config_sync();

    animation_start();
}
