#ifndef lint
static char rcsId[]="$Header: /home/linas/cvsroot/xacc/lib/XmHTML-1.1.0/src/mkStrings.c,v 1.1 1997/11/30 05:13:11 linas Exp $";
#endif
/*****
* mkStrings.c : create a stringtable & defines from a list of strings
*
* This file Version	$Revision: 1.1 $
*
* Creation date:		Tue Sep  2 01:13:25 GMT+0100 1997
* Last modification: 	$Date: 1997/11/30 05:13:11 $
* By:					$Author: linas $
* Current State:		$State: Exp $
*
* Author:				newt
*
* Copyright (C) 1994-1997 by Ripley Software Development 
* All Rights Reserved
*
* This file is part of the XmHTML Widget Library
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the Free
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/
/*****
* ChangeLog 
* $Log: mkStrings.c,v $
* Revision 1.1  1997/11/30 05:13:11  linas
* import XmHTML source for the help widget
*
*****/ 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

/*** External Function Prototype Declarations ***/

/*** Public Variable Declarations ***/

/*** Private Datatype Declarations ****/
#define MKSTRINGS_VERSION		"mkStrings Version 1.00"

/*** Private Function Prototype Declarations ****/

/*** Private Variable Declarations ***/

/*****
* Name:			main
* Return Type:	int
* Description:	generates the XmHTML String table
* In:
*	argc:		no of args, must be exactly 2
*	argv:		array of command line options.
* Returns:
*	EXIT_FAILURE upon failure, EXIT_SUCCESS otherwise.
* Note:
*	this small tool takes an ordered list of strings (given via stdin),
*	and generates the XmHTML string table when called with the ``c'' arg.
*	It generates a corresponding header file when called with the ``h'' arg.
*	Output goes to stdout.
*	The generated header file must be incorporated in HTML.h.
*	The generated c file will be compiled in.
*****/
int
main(int argc, char **argv)
{
	char name[78];
	int len, curr_size = 0;
	time_t now;

	if(argc != 2 || (argv[1][0] != 'c' && argv[1][0] != 'h'))
		exit(EXIT_FAILURE);

	now = time(NULL);
	printf("/*****\n");
	printf("* Automatically generated file.\n");
	printf("*  ***DO NOT EDIT THIS FILE***\n");
	printf("*****/\n");
	printf("/*****\n");
	printf("* %s, Build Date: %s %s\n", MKSTRINGS_VERSION, __DATE__, __TIME__);
	printf("* File created at: %s", ctime(&now));
	printf("*****/\n");

	/* generate a c-source file */
	if(argv[1][0] == 'c')
	{
		printf("\n#include <Xm/XmP.h>\n");
		printf("#if XtSpecificationRelease < 6\n");
		printf("#include <X11/IntrinsicP.h>\n");
		printf("#endif\n\n");

		printf("/*****\n* The missing commas are intentional. Let the "
			"compiler\n* concatenate the strings\n*****/\n\n");
		printf("_XmConst char _XmHTMLStrings[] =\n");
		while((fgets(name, 78, stdin)) != NULL)
		{
			name[strlen(name)-1] = '\0';	/* strip newline */
			printf("/* %5i */ \"%s\\0\"\n", curr_size, name);
			curr_size += strlen(name)+1;
		}
		printf("/* ????? */\n\"\\0\";\n");
	}
	else	/* need a header file */
	{
		printf("\n#ifndef __XmHTML_Strings_h__\n");
		printf("#define __XmHTML_Strings_h__\n");
		printf("\n_XFUNCPROTOBEGIN\n");

		printf("\n/*****\n* Don't define XmHTML_STRINGDEFINES if you want to "
			"save space\n*****/\n");

		printf("\n#ifndef XmHTML_STRINGDEFINES\n");
		printf("# ifndef _XmConst\n");
		printf("#  define _XmConst\n");
		printf("# endif\n");
		printf("extern _XmConst char _XmHTMLStrings[];\n");
		printf("#endif\n\n");
		
		while((fgets(name, 78, stdin)) != NULL)
		{
			name[strlen(name)-1] = '\0';	/* strip newline */

			printf("\n#ifdef XmHTML_STRINGDEFINES\n");
			if(isupper(name[0]))
			{
				printf("# ifndef XmC%s\n", name);
				printf("#  define XmC%s \"%s\"\n", name, name);
				printf("# endif\n");
				printf("# ifndef XmR%s\n", name);
				printf("#  define XmR%s \"%s\"\n", name, name);
				printf("# endif\n");
			}
			else
			{
				printf("# ifndef XmN%s\n", name);
				printf("#  define XmN%s \"%s\"\n", name, name);
				printf("# endif\n");
			}
			printf("#else\n");
			if(isupper(name[0]))
			{
				printf("# ifndef XmC%s\n", name);
				printf("#  define XmC%s ((char *)&_XmHTMLStrings[%i])\n",
					name, curr_size);
				printf("# endif\n");
				printf("# ifndef XmR%s\n", name);
				printf("#  define XmR%s ((char *)&_XmHTMLStrings[%i])\n",
					name, curr_size);
				printf("# endif\n");

			}
			else
			{
				printf("# ifndef XmN%s\n", name);
				printf("#  define XmN%s ((char *)&_XmHTMLStrings[%i])\n",
					name, curr_size);
				printf("# endif\n");
			}
			printf("#endif\n");
			curr_size += strlen(name)+1;
		}
		printf("\n_XFUNCPROTOEND\n");
		printf("\n/* Don't add anything after this endif! */\n");
		printf("#endif /* __XmHTML_Strings_h__ */\n");
	}
	exit(EXIT_SUCCESS);
}
