/*  NCatalog , the GTKtalog ncurses GUI.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <ncurses.h>

extern int largeur;
extern int hauteur;

void display_information(char *info)
{
  unsigned int i;
  unsigned int nb_lignes; 
  int key;
  WINDOW *pad;
  int local_decalage = 0;
  
  
  nb_lignes = 0;
  for(i=0;i<strlen(info);i++)
    {
      if(info[i] == '\n') nb_lignes++;
    }

  if(nb_lignes < hauteur) pad = newpad(hauteur,largeur);
  else pad = newpad(nb_lignes,largeur); 
  
  mvwaddstr(pad,0,0,info);

  prefresh(pad,0,0,0,0,hauteur,largeur); 

  while(1)
    {
      key = getch();
      switch(key)
	{
	case KEY_UP:
	  if(local_decalage > 0) local_decalage--;
	  prefresh(pad,local_decalage,0,0,0,hauteur,largeur);
	  break;
	case KEY_DOWN:
	  if(local_decalage+hauteur < nb_lignes -1) local_decalage++;
	   prefresh(pad,local_decalage,0,0,0,hauteur,largeur);
	  break;
	case KEY_F(10):
	  delwin(pad);
	  return;
	}
    }
}
