/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef FAUT_MARQUER_QUOI_H__
#define FAUT_MARQUER_QUOI_H__

//#define LIBC5

#include <gtk/gtk.h>



unsigned long size_mask;
/*unsigned long style_mask = 3221225472;
unsigned long is_racine = 0;*/
unsigned long is_a_disk;
unsigned long is_a_folder;
unsigned long is_a_file ;

char **categories;
unsigned char nb_categories;
char **descriptions;
unsigned short int nb_descriptions;

typedef struct repertoire{
  char *name;
  unsigned long int taille;//2 derniers bits: type d'objet 00 link, 01 disque, 10 repertoire, 11 fichier 
  unsigned char type;// remplace les deux bits cits ci-dessus(c'est ca la progrs!)
  unsigned long int date;// code en time_t
  unsigned char categorie;
  unsigned short int description;
  char *information;
  unsigned short int nb_files;
  unsigned short int nb_folders;
  struct  repertoire *folders;
  struct repertoire *files;
  struct  repertoire *parent;
} Folder;

Folder racine;
Folder *selected_folder;

/* donnes de stockage des informations sur les categories et les descriptions */
unsigned char nb_categories;
unsigned short int nb_descriptions;
char **categories;
char **descriptions;



/*utilise pour la conversion des donne de Folder en chaine de caractre*/
char date[25];
char taille[15];

void init_folder( Folder *folder, Folder *parent, char *name,unsigned long int taille, unsigned long int date,char style);
void add_folder( Folder *folder, Folder *parent, char *name,char *information,unsigned char type,unsigned long int taille, unsigned long int date,  unsigned char categorie, unsigned short int description);
void change_name(Folder *folder,char *name);
char *get_time(unsigned long nb_sec);
char *get_size(unsigned long nb_octs);
int is_folder(Folder *folder);
int is_disk(Folder *folder);
int is_file(Folder *folder);
int is_link(Folder *folder);

int add_categorie(char *info);
int change_description(Folder *folder,unsigned short desc_nb,int recursive,char *info);



//gestion des fichiers
char *curent_filename;
char *load_filename;
int is_modified;
int have_to_quit;
int have_to_clear;
int have_to_load;
int canceled;

//fonctions d'interface a partager
void update_tree();
void clear_all(GtkWidget *w, gpointer data) ;
void affichage_tree();
void fast_save(GtkWidget *w, gpointer data);
void new_file(GtkWidget *w, gpointer data);

//variable globale contenant le path du disque
gchar *disk_path; 



char *text_viewer;
char *html_viewer;
char *mount;
char *umount;
//char *device_type;
//char *device;
char *mount_point;
char *fast_name;


//Liste des option d'inclusion de fichiers dans la base de donnes!
typedef struct a_inclure{
  char *type;
  char *prog;
  char *arg;
  char *viewer;
  char *viewerarg;
} IData;

IData *IncludeData;
unsigned int nbIncludeData;



#endif
