
#include "triage.h"
#include "render.h"
#include "lispassert.h"
#include "pixels.h"
#include "transforms.h"

CTriage::CTriage(CTexture2d& aTexture,CTexture2d& aDepth)
    : iTexture(aTexture),iDepth(aDepth)
{
    LISPASSERT(aTexture.Width() == aDepth.Width());
    LISPASSERT(aTexture.Height() == aDepth.Height());
}

CTriage::~CTriage()
{
}


void CTriage::RotateX(PlatInt aAngle)
{
    CMatrix m;
    IdentityMatrix(m);
    ::RotateX(m,Trig(),aAngle);
    Transform().Apply(m);
}
void CTriage::RotateY(PlatInt aAngle)
{
    CMatrix m;
    IdentityMatrix(m);
    ::RotateY(m,Trig(),aAngle);
    Transform().Apply(m);
}
void CTriage::RotateZ(PlatInt aAngle)
{
    CMatrix m;
    IdentityMatrix(m);
    ::RotateZ(m,Trig(),aAngle);
    Transform().Apply(m);
}

void CTriage::Translate(Fixed aX, Fixed aY, Fixed aZ)
{
    CMatrix m;
    IdentityMatrix(m);
    ::Translate(m,aX,aY,aZ);
    Transform().Apply(m);
}

template<class T>
inline void CullTriangle(CVector& v0, PlatPixel c0,
                         CVector& v1, PlatPixel c1,
                         CVector& v2, PlatPixel c2, 
                         CTriage& aTriage, 
                         T& aPixelize)
{
  if (aTriage.Flag(KFlagFrontFace))
  {//Frontface culling
    FrontCulledTriangle(v0, c0,v1, c1, v2, c2, aPixelize);
  }
  else if (aTriage.Flag(KFlagBackFace))
  { // backface culling
    BackCulledTriangle(v0, c0,v1, c1, v2, c2, aPixelize);
  }
  else
  { // no culling
    UnCulledTriangle(v0, c0,v1, c1, v2, c2, aPixelize);
  }
}




void CTriage::Line(CVector& vv0, PlatPixel c0, CVector& vv1, PlatPixel c1)
{
    CVector v0,v1;
    PlatInt x0,y0,z0,x1,y1,z1;
    Transform().Transform(v0,vv0);
    Transform().Transform(v1,vv1);

    UnFixVector(x0, y0, z0, v0);
    UnFixVector(x1, y1, z1, v1);
    
    ClampPosition<ZBuffer<AlphaBlend<WritePixel> > > pixelize(*this);
    ::Line(x0, y0, z0, c0, x1, y1, z1, c1, pixelize);
}

void CTriage::Triangle(CVector& vv0, PlatPixel c0,
                       CVector& vv1, PlatPixel c1,
                       CVector& vv2, PlatPixel c2)
{
    CVector v0,v1,v2;
    Transform().Transform(v0,vv0);
    Transform().Transform(v1,vv1);
    Transform().Transform(v2,vv2);
    ClampPosition<ZBuffer<AlphaBlend<WritePixel> > > pixelize(*this);
    CullTriangle(v0, c0, v1, c1, v2, c2, *this, pixelize);
}

void CTriage::Quad(CVector& vv0, PlatPixel c0,
                   CVector& vv1, PlatPixel c1,
                   CVector& vv2, PlatPixel c2,
                   CVector& vv3, PlatPixel c3)
{
  Triangle(vv0,c0,vv2,c2,vv3,c3);
  Triangle(vv0,c0,vv3,c3,vv1,c1);
}
