
#ifndef __hershey_h__
#define __hershey_h__

#include "triagetypes.h"
#define HORIZONTAL_CENTER  0
#define HORIZONTAL_LEFT    1
#define HORIZONTAL_RIGHT   2
#define HORIZONTAL_NORMAL  1

#define VERTICAL_TOP       0
#define VERTICAL_HALF      1
#define VERTICAL_CAP       2
#define VERTICAL_BOTTOM    3
#define VERTICAL_NORMAL    3

#define MAX_CHARACTERS   256
#define MAX_POINTS       150

#include "graphics.h"
#include "fontarrays.h"

class CHersheyFont
{
public:
    CHersheyFont(PlatCharPtr aFontFileName);
    ~CHersheyFont();
    void drawString (PlatCharPtr text, int x, int y, Graphics& g);
    void stringLimit (Rectangle& r, PlatCharPtr text, int x, int y, Graphics& g);
//TODO    void setRotation (double theta);
    void setWidth (float width);
    void setHeight (float height);
    void setVerticalAlignment (int alignment);
    void setHorizontalAlignment (int alignment);
    void setItalics (PlatBoolean flag);
    void setItalicsSlant (float slant);
    void setLineWidth (int width);
    int drawText (PlatCharPtr text,
                  int xc,
                  int yc,
                  float width,
                  float height,
                  int Horizontal_Alignment,
                  int Vertical_Alignment,
                  double theta,
                  PlatBoolean Draw,
                  Rectangle& r,
                  Graphics& g
                 );
protected:

    void LoadHersheyFontFromMemory (PlatCharPtr fontname);
    int getIntFromMemory (PlatCharPtr filename, int* pos, int n);

    void calculateCharacterSize (int j, int xadj);
    int fontAdjustment (PlatCharPtr fontname);

    int transformX (int xoffset, int px, int minx, float mag);
    int transformY (int yoffset, int py, int miny, float mag);

    void drawFontLine (int x1,
                       int y1,
                       int x2,
                       int y2,
                       int width,
                       Graphics& g
                      );

    void drawCharacter (int xp,
                    int yp,
                    int rotpx,
                    int rotpy,
                    float width,
                    float height,
                    PlatBoolean rotate,
                    float sinTheta,
                    float cosTheta,
                    PlatBoolean Draw,
                    Rectangle& r,
                    char Vectors[2][MAX_POINTS],
                    int numberOfPoints,
                    int minX,
                    int characterSetMinY,
                    PlatBoolean Italics,
                    float slant,
                    Graphics& g
                   );


public: //@@@
protected: //@@@
   int X;
   int Y;

   float hersheyWidth;
   float hersheyHeight;
   int hersheyLineWidth;
   int hersheyHorizontalAlignment;
   int herhseyVerticalAlignment;
//   double hersheyTheta;
   PlatBoolean hersheyItalics;
   float hersheyItalicSlant;
   int characterSpacing;
   
   char characterVectors[MAX_CHARACTERS][2][MAX_POINTS];
   int numberOfPoints[MAX_CHARACTERS];
   int *characterMinX;
   int *characterMaxX;
   int characterSetMinY;
   int characterSetMaxY;
   int charactersInSet;
};


#endif

