
#include <ctype.h>
#include <stdio.h>
#include <assert.h>
#include "uncgi.h"

#define ishex(x) (((x) >= '0' && (x) <= '9') || ((x) >= 'a' && (x) <= 'f') || \
		  ((x) >= 'A' && (x) <= 'F'))


/*
 * Convert two hex digits to a value.
 */
static int htoi(char	*s)
{
	int	value;
	char	c;

	c = s[0];
	if (isupper(c))
		c = tolower(c);
	value = (c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10) * 16;

	c = s[1];
	if (isupper(c))
		c = tolower(c);
	value += c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10;

	return (value);
}


/*
 * Get rid of all the URL escaping in a string.  Modify it in place, since
 * the result will always be equal in length or smaller.
 */

//TODO unused
void url_unescape(char *str)
{
    char *dest = str;

    while (str[0])
    {
        if (str[0] == '+')
            dest[0] = ' ';
        else if (str[0] == '%' && ishex(str[1]) && ishex(str[2]))
        {
            dest[0] = (char) htoi(str + 1);
            str += 2;
        }
        else
            dest[0] = str[0];

        str++;
        dest++;
    }

    dest[0] = '\0';
}



/*
 * Get rid of all the URL escaping in a string.  Modify it in place, since
 * the result will always be equal in length or smaller.
 */
void url_unescapelist(CgiArgList *arglist,char *str)
{
    char *dest;

    {
        char *end;
        assert((*str)=='?');
        *str='\0';

        end=str-1;
        while (*end != '/')
        {
            end--;
        }

        arglist->command = end+1;
        
        str++;
        end=str;
        while ((*end) && !isspace(*end))
        {
            end++;
        }
        *end='\0';
    }
    dest = str;

    arglist->nrargs = 0;
    arglist->variables[0] = str;

    while (str[0])
    {
        if (str[0] == '+')
        {
            dest[0] = ' ';
        }
        else if (str[0] == '&')
        {
            dest[0] = '\0';
            arglist->variables[arglist->nrargs] = dest+1;
        }
        else if (str[0] == '=')
        {
            dest[0] = '\0';
            arglist->values[arglist->nrargs] = dest+1;
            arglist->nrargs++;
        }
        else if (str[0] == '%' && ishex(str[1]) && ishex(str[2]))
        {
            dest[0] = (char) htoi(str + 1);
            str += 2;
        }
        else
            dest[0] = str[0];

        str++;
        dest++;
    }

    dest[0] = '\0';
}

void display_cgi_vars(CgiArgList *arglist)
{
    int i;
    printf("command: [%s]\n",arglist->command);
    for (i=0;i<arglist->nrargs;i++)
    {
        printf("[%s] = [%s]\n",arglist->variables[i],arglist->values[i]);
    }
}

