#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <sys/ioctl.h>


void YacasServerSendString(char* the_address,char* str,char* buffer,int max)
{
    int sockfd;
    int len;
    struct sockaddr_in address;
    int result;
    int fd;
    fd_set readfds, testfds;

    buffer[0]='\0';
    
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    address.sin_family = AF_INET;
    address.sin_addr.s_addr = inet_addr(the_address);
    address.sin_port = htons(9734);
    len = sizeof(address);
    result = connect(sockfd, (struct sockaddr *)&address, len);

    if(result == -1)
    {
        printf("Server not responding!\n");
    }
    else
    {
        write(sockfd, str, strlen(str));

        FD_ZERO(&readfds);
        FD_SET(sockfd, &readfds);

        testfds = readfds;

        result = select(FD_SETSIZE, &testfds, (fd_set *)0,
                        (fd_set *)0, (struct timeval *) 0);

        if(result < 1)
        {
            perror("client3");
            exit(1);
        }
        for(fd = 0; fd < FD_SETSIZE; fd++)
        {
            if(FD_ISSET(fd,&testfds))
            {
                int nread;
                ioctl(sockfd, FIONREAD, &nread);
                if (nread>max-1)
                    nread=max-1;
                read(sockfd, buffer, nread);
                buffer[nread]='\0';
            }
        }
        close(sockfd);
    }
}
