#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "strrep.h"

#define SIZE_MULTIPLIER		5



/* 
 * strrep: iterativeley replace a string in a string and make sure 
 * 	we don't overflow. All memory is allocated using malloc and
 * 	the returned pointer should be disposed of using free() not 
 * 	the C++ delete.
 *
 * This is actually plain C code (regardless of the *.cc file it's in)
 */ 
char *strrep (char *src, char *psrc, char *pdst)
{
	int	srcSizeM = strlen(src)*SIZE_MULTIPLIER;	/* hope that this fits */
	char 	*s = src,				/* moving source pointer */
		*dst = (char *)malloc(srcSizeM),	/* destination array */
		*dp = dst,				/* moving destination pointer */
		*found;	
	int	srcRSize = strlen (psrc),		/* size of source fragment */
		dstRSize = strlen (pdst), 		/* size of replace fragment */
		l; 

	/* iterate through string, looking for pssrc */
	while ((found=strstr (s, psrc)))
		{
		l = found-s;				/* length of piece before found */

		if ((l+dstRSize) > srcSizeM-(dp-dst))
			{
			printf ("strrep buffer overflow ... bailing out\n");
			printf ("recompile with higher SIZE_MULTIPLIER for proper operation\n");
			break;
			}

		strncpy (dp, s, l);			/* copy it */
		dp += l;				/* update dest. marker */
		strncpy (dp, pdst, dstRSize);		/* copy the replace part */
		dp += dstRSize;				/* update dest. marker */
		s = found + srcRSize;			/* update past processed text */
		}


	/* don't forget the possible leftover bit but make *
	 * sure that we didn't break out of the above loop */
	if (!found)
		{
		if (src == s)				/* didn't do anything, return original */
			return src;

		if (strlen(s))				/* copy rest */
			strcpy (dp, s);
		}

	/* make copy with proper sized char array */
	char *t = (char *) malloc (strlen(dst)+1);
	strcpy (t, dst);
	free (dst);
	return t;
}


/*
int main (int argc, char **argv)
{
	char 	*src = "test123test123",
		*psrc = "123",
		*pdst = "4567895", 
		*dest;

	dest = strrep (src, psrc, pdst); 
	printf ("[%s]\n", dest);
}
*/
