/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GLIB_HASH_H
#define _GLIB_HASH_H

#include "glib.h"
#include "GlobalSanityCheck.h"


/*
 *  Glib_Hash: very *simple* wrapper for glib/ghash.c
 */
class Glib_Hash
	{
	public:
				Glib_Hash (GHashFunc hash_func,
				   	   GCompareFunc	key_compare_func);
				~Glib_Hash ();
		void 		insert (gpointer key, gpointer value);
		void 		remove (gconstpointer key);
		gpointer 	lookup (gconstpointer key);
		bool 		lookup_extended(gconstpointer lookup_key,
					gpointer *orig_key, gpointer *value);
		void 		freeze ();
		void 		thaw ();	
		int 		foreach	(GHFunc	func, gpointer user_data);
		gint 		foreach_remove (GHFunc func, gpointer user_data);
		gint 		get_size ();

	private:
		GHashTable		*p_hashTable;

	// C++ sugar
	public:
		bool operator==(const Glib_Hash & rhs)
			{
			if (p_hashTable && rhs.p_hashTable)
				return (p_hashTable==rhs.p_hashTable);
			return (FALSE);
			}
	};


inline Glib_Hash::Glib_Hash (GHashFunc hash_func, GCompareFunc key_compare_func)
{
	SanityCheck::bailout ((!hash_func), "hash_function == NULL", "GlibHash::GlibHash"); 
	SanityCheck::bailout ((!key_compare_func), "key_compare_function == NULL", "GlibHash::GlibHash"); 

	p_hashTable = g_hash_table_new (hash_func, key_compare_func);
}


inline Glib_Hash::~Glib_Hash ()
{
	if (p_hashTable)
		g_hash_table_destroy (p_hashTable);
}


inline void Glib_Hash::insert (gpointer key, gpointer value)
{
	g_hash_table_insert (p_hashTable, key, value);
}


inline void Glib_Hash::remove (gconstpointer key)
{
	g_hash_table_remove (p_hashTable, key);
}


inline gpointer Glib_Hash::lookup (gconstpointer key)
{
	return g_hash_table_lookup (p_hashTable, key);
}


inline bool Glib_Hash::lookup_extended (gconstpointer	lookup_key,
					gpointer	*orig_key,
					gpointer	*value)
{
	return g_hash_table_lookup_extended (p_hashTable, lookup_key, 
										orig_key, value);
}


inline void Glib_Hash::freeze ()
{
	return g_hash_table_freeze (p_hashTable);
}


inline void Glib_Hash::thaw ()
{
	return g_hash_table_thaw (p_hashTable);
}


// slightly different sig from orig: C++ objects to GHRFunc being used
inline gint Glib_Hash::foreach (GHFunc		func,
				gpointer	user_data)
{
	g_hash_table_foreach (p_hashTable, func, user_data);
	return (0);
}


// slightly different sig from orig: C++ objects to GHRFunc being used
inline gint Glib_Hash::foreach_remove (GHFunc  func,
                                       gpointer user_data)
{
	g_hash_table_foreach (p_hashTable, func, user_data);
	return (0);
}


inline gint Glib_Hash::get_size ()
{
	return g_hash_table_size (p_hashTable);
}

#endif // GLIB_HASH_H
