/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_OPEN_GL_AREA_H
#define _TF_OPEN_GL_AREA_H 1
 

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>

#include <gtk--.h>
#include <gtkgl--/glarea.h>

#include "HeightFieldDraw.h"



/*
 * TFOpenGLArea
 * 	This class will be our OpenGL widget of three geometric objects
 */
class TFOpenGLArea:public Gtk_GLArea
{
	public:
				TFOpenGLArea (HeightField *HF);
				~TFOpenGLArea ();

		// take over the impl functions for events 
		virtual void 	realize_impl ();
		virtual gint 	expose_event_impl (GdkEventExpose *e);
		virtual gint 	configure_event_impl (GdkEventConfigure *e);
		virtual gint 	button_press_event_impl (GdkEventButton *e); 
		virtual gint	key_press_event_impl (GdkEventKey *e); 

	private:
		void 		drawTerrain ();
		void		buildMesh (); 
		void 		initGL ();
		void 		setupGL ();
		void 		drawGL ();

		GLuint 			d_terrainList, 		// display lists
					d_normalsList;
		GLuint     		d_meshColumnStep;	// column step factor 1 = all points 
		GLuint     		d_meshRowStep;		// row step factor 1 = all points 
		GLboolean  		d_doDrawNormals;	// draw the normals? 
		GLfloat			***p_meshVertices;	// mesh vertices 
		GLfloat			***p_meshNormals;	// mesh normals 
		HeightField		*p_HF;
		HeightFieldDraw		*p_HFD;
};


#endif

