/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogErode.h"
#include "TFOptions.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogErode::TFDialogErode (HeightField *HF, HeightFieldDraw *HFD)
	        : TFBaseDialog (HF, HFD, "Terraform Erode Dialog", 
			"Erosion Parameters"),
		  d_vbList1 (TRUE, 2),
		  d_vbList2 (TRUE, 2),
		  d_hbHS1 (TRUE, 5),
		  d_hbHS2 (TRUE, 5),
		  d_hbHS3 (TRUE, 5),
		  d_hbSave (TRUE, 5),
		  d_hbTrim (TRUE, 5),
		  d_frm1 (_("Erosion Controls")),
		  d_frm2 (_("Flowmap Controls")),
		  d_adjNTurns (5000, 1000, 25000, 0.01),
		  d_adjMaxElvErode (1.0, 0.1, 1.0, 1),
		  d_adjMaxFlowAge (250, 0, (TFOptions::s_large ? 10000 : 1000), 1),
		  d_hsNTurns (d_adjNTurns),
		  d_hsMaxElvErode (d_adjMaxElvErode),
		  d_hsMaxFlowAge (d_adjMaxFlowAge),
		  d_lblHS1 (_("Number of Iterations")),
		  d_lblHS2 (_("Maximum flowmap age")),
		  d_lblHS3 (_("Elevation Threshold")),
		  d_lblSave (_("Save at max flowmap age")),
		  d_lblTrim (_("Trim local peaks")),
		  d_hSep ()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogErode\n");

	setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Erode: %s"), p_HF->getName());
	p_RB1 = p_RB2 = NULL;
	p_cbTrim = p_cbSave = p_cbSealevel = NULL;
	p_group = NULL;

	d_frm1.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frm1.set_border_width (5);
	d_frm2.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frm2.set_border_width (5);

	buildDialogWindow ();
}


/*
 *  destructor: clean up 
 */
TFDialogErode::~TFDialogErode ()
{
	if (p_RB1) delete p_RB1;
	if (p_RB2) delete p_RB2;
	if (p_cbSealevel) delete p_cbSealevel;
	if (p_cbSave) delete p_cbSave;
	if (p_cbTrim) delete p_cbTrim;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogErode\n");
}


/*
 *  buildErodeFrame: build the frame for the erode parameters
 */
void TFDialogErode::buildErodeFrame ()
{
	d_hbHS1.pack_start (d_lblHS1, TRUE, TRUE, s_HBOff);
	d_lblHS1.show ();
	d_hbHS1.pack_start (d_hsNTurns, TRUE, TRUE, s_HBOff);
	d_hsNTurns.set_digits (0);
	d_hsNTurns.show();
	d_vbList1.pack_start (d_hbHS1, TRUE, TRUE, s_VBOff);
	d_hbHS1.show ();

	d_hbHS2.pack_start (d_lblHS2, TRUE, TRUE, s_HBOff);
	d_lblHS2.show ();
	d_hbHS2.pack_start (d_hsMaxFlowAge, TRUE, TRUE, s_HBOff);
	d_hsMaxFlowAge.set_digits (0);
	d_hsMaxFlowAge.show();
	d_vbList1.pack_start (d_hbHS2, TRUE, TRUE, s_VBOff);
	d_hbHS2.show ();

	d_hbHS3.pack_start (d_lblHS3, TRUE, TRUE, s_HBOff);
	d_lblHS3.show ();
	d_hbHS3.pack_start (d_hsMaxElvErode, TRUE, TRUE, s_HBOff);
	d_hsMaxElvErode.set_digits (2);
	d_hsMaxElvErode.show();
	d_vbList1.pack_start (d_hbHS3, TRUE, TRUE, s_VBOff);
	d_hbHS3.show ();

	d_hbTrim.pack_start (d_lblTrim, TRUE, TRUE, s_HBOff);
	d_lblTrim.show ();
	p_cbTrim = new Gtk_CheckButton ();
	p_cbTrim->set_active (TRUE);
	d_hbTrim.pack_start (*p_cbTrim, TRUE, TRUE, s_HBOff);
	p_cbTrim->show ();
	d_vbList1.pack_start (d_hbTrim, TRUE, TRUE, s_VBOff);
	d_hbTrim.show ();

	p_cbSave = new Gtk_CheckButton ("Save when refreshing Flowmap");
	p_cbSave->set_active (FALSE);
	d_hbSave.pack_start (*p_cbSave, TRUE, TRUE, s_HBOff);
	p_cbSave->show ();
	connect_to_method (p_cbSave->clicked, this, &TFDialogErode::checkboxCallback);
	d_hbSave.pack_start (d_entFileName, TRUE, TRUE, s_HBOff);
	d_entFileName.set_text ("erode.tga");
	d_entFileName.set_sensitive (FALSE);
	d_entFileName.show ();
	d_vbList1.pack_start (d_hbSave, TRUE, TRUE, s_VBOff);
	d_hbSave.show ();

	d_frm1.add (d_vbList1);
	d_vbList1.show ();

	this->d_vbOptions.pack_start (d_frm1, FALSE, TRUE, 2);
	d_frm1.show ();
}


/*
 *  buildFlowmapFrame: build the frame for the flowmap parameters
 */
void TFDialogErode::buildFlowmapFrame ()
{
	p_RB1 = new Gtk_RadioButton ((GSList *)NULL, "Single Flow Direction");
	p_RB1->set_active (TRUE);
	d_vbList2.pack_start (*p_RB1, TRUE, TRUE, s_VBOff);
	p_RB1->show ();

	p_group = p_RB1->group ();
	p_RB2 = new Gtk_RadioButton (p_group, "Multiple Flow Direction");
	d_vbList2.pack_start (*p_RB2, TRUE, TRUE, s_VBOff);
	p_RB2->show ();

	d_vbList2.pack_start (d_hSep, FALSE, FALSE, 0);
	d_hSep.show ();

	p_cbSealevel = new Gtk_CheckButton ("Observe Sealevel");
	p_cbSealevel->set_active (FALSE);
	d_vbList2.pack_start (*p_cbSealevel, TRUE, TRUE, s_VBOff);
	p_cbSealevel->show ();

	d_frm2.add (d_vbList2);
	d_vbList2.show ();

	this->d_vbOptions.pack_start (d_frm2, FALSE, FALSE, s_VBOff);
	d_frm2.show ();
}


/*
 *  fillVBox: fill the dialog's VBox
 */
void TFDialogErode::fillVBox ()
{
	SanityCheck::bailout ((!this->p_frmBase), "TFDialogErode called without Frame label", 
		"TFDialogErode::setHFobjs");

	buildErodeFrame ();
	buildFlowmapFrame ();
}


/*
 *  buildDialogWindow:
 */
void TFDialogErode::buildDialogWindow ()
{
	this->set_usize (400, 450);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	setupVBox ();

	this->p_frmBase->add (this->d_vbOptions);
	fillVBox ();
	fillActionArea ();

	this->d_vbOptions.show ();
	this->show ();
}


/* 
 * checkboxCallback: used so that p_cbSave can (de)activate d_entFileName
 */
void TFDialogErode::checkboxCallback ()
{	
	if (p_cbSave->get_active())
		d_entFileName.set_sensitive (TRUE);
	else
		d_entFileName.set_sensitive (FALSE);
}


/*
 *  buttonCallbackApply: rotate the Height Field
 */
void TFDialogErode::buttonCallbackApply ()
{
	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogErode::buttonCallbackApply");

	int		nTurns, maxFlowAge;
	float		maxElvErode;
	char		*buf=NULL,
			*fName=NULL;
	bool		doSFD=TRUE, observeSea=FALSE, trimLocalPeaks=TRUE;

	nTurns = (int)(d_adjNTurns.get_value());
	maxFlowAge = (int)(d_adjMaxFlowAge.get_value());
	maxElvErode = d_adjMaxElvErode.get_value();

	doSFD = !p_RB2->get_active();
	observeSea = p_cbSealevel->get_active();
	trimLocalPeaks = p_cbTrim->get_active();

	if (p_cbSave->get_active())
		{
		fName = const_cast<char*>(d_entFileName.get_text().c_str());
		fName[d_entFileName.get_text_length()]='\0';
		
		// convert filename to a sprintf mask
		if (fName && strlen(fName))
			{
			char 	*p;

			buf = new char[strlen(fName+10)];
			strcpy (buf, "");
			if ((p=strchr (fName, '.')))
				{
				if (!strstr (fName, "%d"))
					{
					buf = strncat (buf, fName, p-fName);
					buf = strcat (buf, "%d.");
					buf = strcat (buf, p+1);
					fName = buf;
					}
				}
			else
				{
				buf = strcat (buf, fName);
				buf = strcat (buf, "%d");
				buf = strcat (buf, ".tga");
				fName = buf;
				}
					
			}
		else
		if (fName)
			fName = NULL;
		}

	if ((nTurns > maxFlowAge) && (p_HF->getSealevel() < maxElvErode))
		{
		p_HFO->erode (nTurns, maxFlowAge, maxElvErode, fName, 
			trimLocalPeaks, doSFD, !observeSea, p_HFD);
		p_HFD->draw ();
		}
	else
		SanityCheck::warning ((TRUE), "maxFlowAge>nTurns", "TFDialogErode::buttonCallbackApply");

	if (buf)
		delete [] buf;
	this->b_applyHit = TRUE;
}
