/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <string.h>
#include <stdlib.h>
#include "GuiDialogOAC.h"
#include "GlobalTrace.h"



/*
 *  constructor: initialize everything 
 */
GuiDialogOAC::GuiDialogOAC(char *windowTitle, char *frameTitle)
	      : Gtk_Dialog (),
		d_btnOK ("OK"),
		d_btnApply ("Apply"),
		d_btnCancel ("Cancel")
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ GuiDialogOAC\n");

	if (windowTitle)
		p_windowTitle = strdup (windowTitle);
	else
		p_windowTitle = strdup ("GuiDialogOAC Window");

	if (frameTitle)
		p_frameTitle = strdup (frameTitle);
	else
		p_frameTitle = NULL;

	p_frmBase = NULL;
	b_applyHit = FALSE;

	this->set_position (GTK_WIN_POS_MOUSE);		
}


/*
 *  destructor: clean up, free allocated memory
 */
GuiDialogOAC::~GuiDialogOAC()
{
	if (p_windowTitle) free (p_windowTitle);	// c-type alloc from strdup
	if (p_frameTitle) free (p_frameTitle);	// c-type alloc from strdup
	if (p_frmBase) delete p_frmBase;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- GuiDialogOAC\n");
}


/*
 *  (virtual) buildDialogWindow: call the proper functions to setup the dialog
 */
void GuiDialogOAC::buildDialogWindow ()
{
	this->set_usize (300, 120);
	this->set_title (p_windowTitle);

	this->get_vbox()->set_border_width (2);

	setupVBox ();
	fillVBox ();
	fillActionArea ();

	if (p_frmBase)
		p_frmBase->show ();
	this->show ();
}


/*
 *  setupVBox: setup the basic frame of the vbox if necessary 
 */
void GuiDialogOAC::setupVBox ()
{
	if (p_frameTitle)
		{
		p_frmBase = new Gtk_Frame (p_frameTitle);
		p_frmBase->set_shadow_type (GTK_SHADOW_ETCHED_IN);
		p_frmBase->set_border_width (6);
		this->get_vbox()->pack_start (*p_frmBase, TRUE, TRUE, 0);
		p_frmBase->show ();	
		}
	this->get_vbox()->show ();
}


/*
 *  (virtual) fillVBox: fill the dialog's VBox 
 */
void GuiDialogOAC::fillVBox ()
{
}


/*
 *  fillActionArea: fill the dialog's action area 
 */
void GuiDialogOAC::fillActionArea ()
{
	connect_to_method (d_btnOK.clicked, this, &GuiDialogOAC::buttonCallbackOK);
	this->get_action_area()->pack_start (d_btnOK, TRUE, TRUE, 0);
	d_btnOK.show ();

	connect_to_method (d_btnApply.clicked, this, &GuiDialogOAC::buttonCallbackApply);
	this->get_action_area()->pack_start (d_btnApply, TRUE, TRUE, 0);
	d_btnApply.show ();

	connect_to_method (d_btnCancel.clicked, this, &GuiDialogOAC::buttonCallbackCancel);
	this->get_action_area()->pack_start (d_btnCancel, TRUE, TRUE, 0);
	d_btnCancel.show ();
}


/*
 *  (virtual) buttonCallbackOK: process the OK button press
 */
void GuiDialogOAC::buttonCallbackOK ()
{
	this->hide ();
	gdk_flush ();

	// if apply has been hit in the previous round, just close the window
	if (!b_applyHit)
		buttonCallbackApply ();
	b_applyHit = FALSE;
}


/*
 *  (virtual) buttonCallbackApply: process the Apply button press
 */
void GuiDialogOAC::buttonCallbackApply ()
{
	cout << "GuiDialogOAC: Default Callback Apply\n";
	b_applyHit = TRUE;
}


/*
 *  (virtual) buttonCallbackCancel: process the Cancel button press
 */
void GuiDialogOAC::buttonCallbackCancel ()
{
	this->hide ();
	b_applyHit = FALSE;
}


/*
 *  (virtual) delete_event_impl: provide delete event implementation 
 */
gint GuiDialogOAC::delete_event_impl(GdkEventAny *e)
{
	this->hide ();
	return (0);
}

