/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _FILEIO_H
#define _FILEIO_H 1

#include <stdio.h>
#include "GlobalDefs.h"


/*
 *  FileIO: class to handle some high level file operations
 */
class FileIO
	{
	public:
				FileIO (const char *fName);
				~FileIO ();
		FILE		*open (char *mode);	// r or w 
		int		close ();	
		bool		exists ();
		bool 		promptOverwrite ();
		char		*getBasename ();
		char		*getExtension (int include_dot=FALSE);
		FILE		*getFilePtr ()	{ return d_File; }
		char		*getName ()	{ return d_fName; }

		int		get_hf_file_type (const char *fname);

	private:
		FILE		*d_File;			// File pointer
		char		*d_fName; 			// File name 
		char		*d_baseName; 		// base file name (`cut -f1 -d.`)
		char		*d_extension; 		// extension after last dot
	};


#endif // _FILEIO_H

