/*
  Win.h last modified 28/APR by Dave Lawrence
  For the latest version of XTux, see http://www.adelaide.net.au/~philaw
*/

/* Text win dimensions */
#define TWINW 200
#define TWINH 160

#define SPLASH_IMG_W 192
#define SPLASH_IMG_H 232

#define SPLASH_W SPLASH_IMG_W
#define SPLASH_H SPLASH_IMG_H + 24 /* 256 */

#define MED_FONT_18 "-adobe-helvetica-medium-r-*-*-18-*-*-*-*-*-*-*"
#define BOLD_FONT_14 "-*-helvetica-bold-r-*-*-14-*-*-*-*-*-iso8859-*"
#define BOLD_FONT_24 "-*-helvetica-bold-r-*-*-24-*-*-*-*-*-iso8859-*"

#define MAP_STR_LEN 37 /* 32 + 5(for "map: " */
#define BAR_X 0
#define BAR_Y 0
#define BAR_WIDTH 188
#define BAR_HEIGHT 58
#define BAR_XOFF 46
#define BAR_YOFF 27
#define CAFF_BAR_WIDTH 100
#define CAFF_BAR_HEIGHT 8
#define BAR_COLOR WhitePixel(display, screen)
#define WEAP_IMG_X 196 /* bar ends @ 188 */
#define WEAP_IMG_Y VIEW_H

#define STATUS_HEIGHT 58
#define STATUS_FONT med_font_18

void create_window(void);
void draw_text_window(char *mesg);
void setup_gcs(void);
void alloc_color(int i, int r, int g, int b);
void create_private_colormap();
void splash_screen_print(char *msg);
int menu(char *map_name, int *type);
void load_fonts(void);
void blit_buffer_to_screen(void);
void update_screen(struct map_t *map, int x_off, int y_off);
void update_animation(void);
void draw_entities(int x_off, int y_off);
void update_window(void);
void print(char *msg, Drawable dest, int x, int y, XFontStruct *font);
void clear_area(Drawable drwbl, int x, int y,int width, int height, int color);
void blit(Drawable src, Drawable dest, int x, int y, int width, int height);
void trans_blit(Drawable src, Drawable dest, int x, int y,
		int width, int height, Drawable clip_mask);
void offset_blit(Drawable src, Drawable dest, int x, int y,
		 int width, int height,  int x_o, int y_o);
void update_caff_bar(int health);
void draw_status_bar(struct map_t *map, int weap_type);
void draw_map(struct map_t *map, int x_off, int y_off);
void flash_color(int c);
void die(char *, int exit_status);

typedef struct {
  int pixel;
  int r, g, b;
}ColorTable;





