/* 
   Functions.m

   Generic Functions for the GNUstep GUI X/DPS Library.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Author:  Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: September 1996
   
   This file is part of the GNUstep GUI X/DPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/ 

#include "config.h"
#include <DPS/psops.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSCStringText.h>
#include <AppKit/NSEvent.h>
#include <gnustep/xdps/NSDPSContextWindow.h>
#include "drawingfuncs.h"

#define	CUR_CONTEXT	((NSDPSContext*)[NSDPSContext currentContext])

//
// Rectangle Drawing Functions
//
//
// Optimize Drawing
//
void NSEraseRect(NSRect aRect)
{
  PSgsave();
  PSsetgray(1);
  PSrectfill(aRect.origin.x, aRect.origin.y, 
	     aRect.size.width, aRect.size.height);
  PSgrestore();
}

void NSHighlightRect(NSRect aRect)
{
  float x, y, w, h;
  NSDPSContext *ctxt;

  ctxt = (NSDPSContext *)[NSGraphicsContext currentContext];
  x = NSMinX(aRect);
  y = NSMinY(aRect);
  w = NSWidth(aRect);
  h = NSHeight(aRect);
  [ctxt DPScompositerect: x : y : w : h : NSCompositeHighlight];

  [[[ctxt focusView] window] flushWindow];
}

void NSRectClip(NSRect aRect)
{  
  float x, y, w, h;

  x = NSMinX(aRect);
  y = NSMinY(aRect);
  w = NSWidth(aRect);
  h = NSHeight(aRect);

  PSrectclip(x, y, w, h);
  PSnewpath();
}

void NSRectClipList(const NSRect *rects, int count)
{
  int i;
  for (i=0; i<count; i++)
    NSRectClip(rects[i]);
}

void NSRectFill(NSRect aRect)
{
  PSrectfill(aRect.origin.x, aRect.origin.y, 
	     aRect.size.width, aRect.size.height);
}

void NSRectFillList(const NSRect *rects, int count)
{
  int i;

  for (i = 0;i < count; ++i)
    PSrectfill(rects[i].origin.x, rects[i].origin.y, 
	       rects[i].size.width, rects[i].size.height);
}

void NSRectFillListWithGrays(const NSRect *rects, 
			     const float *grays, int count)
{
  int i;

  for (i = 0;i < count; ++i)
    {
      PSsetgray(grays[i]);
      PSrectfill(rects[i].origin.x, rects[i].origin.y, 
		 rects[i].size.width, rects[i].size.height);
    }
}

//
// Draw a Bordered Rectangle
//
void NSDrawButton(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }

  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawButton (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSDrawGrayBezel(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawGrayBezel (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSDrawGroove(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawGroove (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSDrawWhiteBezel(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawWhiteBezel (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSDrawBezel(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawBezel (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void GSDrawPressedPushButton(NSRect rect, NSRect clipRect)
{
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  PSWDrawPressedPushButton (rect.origin.x, rect.origin.y,
		       rect.size.width, rect.size.height);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void GSDrawPressedToggleButton(NSRect rect, NSRect clipRect)
{
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  PSWDrawPressedToggleButton (rect.origin.x, rect.origin.y,
		       rect.size.width, rect.size.height);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSFrameRect(NSRect rect)
{
  PSWFrameRect (rect.origin.x, rect.origin.y,
		  rect.size.width, rect.size.height);
}

void NSFrameRectWithWidth(NSRect rect, float frameWidth)
{
  PSWFrameRectWithWidth (rect.origin.x, rect.origin.y,
			   rect.size.width, rect.size.height, frameWidth);
}

NSRect NSDrawTiledRects(NSRect boundsRect, NSRect clipRect, 
			const NSRectEdge *sides, const float *grays, 
			int count)
{
	return NSZeroRect;
}

//
// Color Functions
//
//
// Get Information About Color Space and Window Depth
//
const NSWindowDepth *NSAvailableWindowDepths(void)
{
	return NULL;
}

NSWindowDepth NSBestDepth(NSString *colorSpace, 
			  int bitsPerSample, int bitsPerPixel, 
			  BOOL planar, BOOL *exactMatch)
{
	return 0;
}

int NSBitsPerPixelFromDepth(NSWindowDepth depth)
{
	return 0;
}

int NSBitsPerSampleFromDepth(NSWindowDepth depth)
{
	return 0;
}

NSString *NSColorSpaceFromDepth(NSWindowDepth depth)
{
	return nil;
}

int NSNumberOfColorComponents(NSString *colorSpaceName)
{
	return 0;
}

BOOL NSPlanarFromDepth(NSWindowDepth depth)
{
	return NO;
}

//
// Read the Color at a Screen Position
//
NSColor *NSReadPixel(NSPoint location)
{
	return nil;
}

//
// Text Functions
//
//
// Filter Characters Entered into a Text Object
//
unsigned short NSEditorFilter(unsigned short theChar, 
			      int flags, NSStringEncoding theEncoding)
{
	return 0;
}

unsigned short NSFieldFilter(unsigned short theChar, 
			     int flags, NSStringEncoding theEncoding)
{
	return 0;
}

//
// Calculate or Draw a Line of Text (in Text Object)
//
int NSDrawALine(id self, NSLayInfo *layInfo)
{
	return 0;
}

int NSScanALine(id self, NSLayInfo *layInfo)
{
	return 0;
}

//
// Calculate Font Ascender, Descender, and Line Height (in Text Object)
//
void NSTextFontInfo(id fid, 
		    float *ascender, float *descender, 
		    float *lineHeight)
{}

//
// Access Text Object's Word Tables
//
NSData * NSDataWithWordTable(const unsigned char *smartLeft,
			     const unsigned char *smartRight,
			     const unsigned char *charClasses,
			     const NSFSM *wrapBreaks,
			     int wrapBreaksCount,
			     const NSFSM *clickBreaks, 
			     int clickBreaksCount, 
			     BOOL charWrap)
{
	return nil;
}

void NSReadWordTable(NSZone *zone,
		     NSData *data,
		     unsigned char **smartLeft,
		     unsigned char **smartRight,
		     unsigned char **charClasses,
		     NSFSM **wrapBreaks,
		     int *wrapBreaksCount,
		     NSFSM **clickBreaks,
		     int *clickBreaksCount, 
		     BOOL *charWrap)
{}

//
// Array Allocation Functions for Use by the NSText Class
//
NSTextChunk *NSChunkCopy(NSTextChunk *pc, NSTextChunk *dpc)
{
	return NULL;
}

NSTextChunk *NSChunkGrow(NSTextChunk *pc, int newUsed)
{
	return NULL;
}

NSTextChunk *NSChunkMalloc(int growBy, int initUsed)
{
	return NULL;
}

NSTextChunk *NSChunkRealloc(NSTextChunk *pc)
{
	return NULL;
}

NSTextChunk *NSChunkZoneCopy(NSTextChunk *pc, 
                             NSTextChunk *dpc,
                             NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneGrow(NSTextChunk *pc, int newUsed, NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneMalloc(int growBy, int initUsed, NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneRealloc(NSTextChunk *pc, NSZone *zone)
{
	return NULL;
}


//
// Imaging Functions
//
//
// Copy an image
//
void NSCopyBitmapFromGState(int srcGstate, NSRect srcRect, NSRect destRect)
{}

void NSCopyBits(int srcGstate, NSRect srcRect, NSPoint destPoint)
{
  XRectangle	dst;
  XRectangle    src;
  Drawable source, draw;
  NSWindow *window;
  NSDPSContext *ctxt;
  gswindow_device_t *windev;

  ctxt = (NSDPSContext *)GSCurrentContext();
  window = [[GSCurrentContext() focusView] window];
  windev = [NSDPSContext _windowWithTag: [window windowNumber]];
  draw = (windev->buffer) ? windev->buffer : windev->ident;
  if (draw == 0)
    return;

  source = 0;
  if (srcGstate != 0)
    {
      int gc, x, y;
      NSRect tRect = [ctxt XRectFromUserRect: srcRect];
      PSgsave();
      PSsetgstate(srcGstate);
      PScurrentXgcdrawable(&gc, (int *)(&source), &x, &y);
      if (source == 0)
        return;
      NSDebugLLog (@"Copy", @"Orig  %@\n", NSStringFromRect(srcRect));
      srcRect = [ctxt XRectFromUserRect: srcRect];
      NSDebugLLog (@"Copy", @"XCoor %@\n", NSStringFromRect(srcRect));
      PSgrestore();
    }
  else
    {
      source = draw;
      srcRect = [ctxt XRectFromUserRect: srcRect];
    }
  NSDebugLLog (@"Copy", @"ODest %@\n", NSStringFromPoint(destPoint));
  destPoint = [ctxt XPointFromUserPoint: destPoint];
  /* FIXME: Why is this needed? */
  if (![[GSCurrentContext() focusView] isFlipped])
    destPoint.y -= NSHeight(srcRect);
  NSDebugLLog (@"Copy", @"XDest %@\n", NSStringFromPoint(destPoint));

  src.x = NSMinX(srcRect); src.y = NSMinY(srcRect);
  src.width = NSWidth(srcRect); src.height = NSHeight(srcRect);
  dst.x = destPoint.x; dst.y = destPoint.y;
  NSDebugLLog (@"NSWindow", @"Copying bitmap from (%d %d %d %d) to (%d %d)\n",
  	src.x, src.y, src.width, src.height, dst.x, dst.y);
  XCopyArea([ctxt xDisplay], source, draw, windev->gc,
                src.x, src.y, src.width, src.height, dst.x, dst.y);
}

//
// Render Bitmap Images
//
static	char *hex = "0123456789abcdef";
#define	PUTHEX(cont, c)	DPSPrintf(cont, "%c%c", hex[((c)>>4)&0xf], hex[(c)&0xf]);

void NSDrawBitmap(NSRect rect,
                  int pixelsWide,
                  int pixelsHigh,
                  int bitsPerSample,
                  int samplesPerPixel,
                  int bitsPerPixel,
                  int bytesPerRow, 
                  BOOL isPlanar,
                  BOOL hasAlpha, 
                  NSString *colorSpaceName, 
                  const unsigned char *const data[5])
{
  int pixels;
  DPSContext ctxt;
  ctxt = DPSGetCurrentContext();

  /* Save scaling */
  PSmatrix(); PScurrentmatrix();
  PSmoveto(NSMinX(rect), NSMinY(rect));
  PSscale(NSWidth(rect), NSHeight(rect));

  /* Prepare the image operands */
  if (bitsPerSample == 0)
    bitsPerSample = 8;
  DPSPrintf(ctxt, "%d %d %d\n", pixelsWide, pixelsHigh, bitsPerSample);
  DPSPrintf(ctxt, "[%lu 0 0 -%lu 0 %lu]\n", pixelsWide, pixelsHigh, 
	    pixelsHigh);

  /* Send the data source */
  pixels = bytesPerRow * pixelsHigh;
  if (isPlanar)
    {
      int i;
      for (i = 0; i < samplesPerPixel; i++)
	PSsendchararray(data[i], pixels);
    }
  else
    {
      int i, j, pos, row, col;
      float adjust;
      unsigned char dot;
      DPSPrintf(ctxt, "<");
      j = 0;
      pos = 0;
      for (row = 0; row < pixelsHigh; row++)
	for (col = 0; col < pixelsWide; col++)
	  for (i = 0; i < samplesPerPixel; i++)
	    {
	      if (hasAlpha)
		{
		  adjust = data[0][pos + (3 - (pos % 4))];
		  adjust = adjust/255;
		}
	      else
		adjust = 1;
	      if ((hasAlpha) && ((pos % 4) != 3))
		{
		  dot = 255 + (data[0][pos] - 255)*adjust;
		  PUTHEX(ctxt, dot);
		  ++j;
		}
	      ++pos;
	      if (j == 33)
		{
		  j = 0;
		}
	    }
      DPSPrintf(ctxt, "> \n");
    }

  /* Now image it */
  if (samplesPerPixel > 1)
    {
      if (hasAlpha)
	samplesPerPixel -= 1;
      PSsendboolean(isPlanar);
      PSsendint(samplesPerPixel);
      /* alphaimage doesn't work on DGS yet. Maybe not at all on other impl */
      if (hasAlpha)
	DPSPrintf(ctxt, "colorimage\n");
      else
	PScolorimage();
    }
  else
    PSimage();
  
  /* Restore original scaling */
  PSsetmatrix();
}

//
// Other Application Kit Functions
//

//
// Play the System Beep
//
void NSBeep(void)
{
  Display *xDisplay = [(NSDPSContext *)[NSDPSContext currentContext]
					xDisplay];

  XBell(xDisplay, 50);
}

//
// Draw a Distinctive Outline around Linked Data
//
void NSFrameLinkRect(NSRect aRect, BOOL isDestination)
{}

float NSLinkFrameThickness(void)
{
	return 0;
}

//
// Convert an Event Mask Type to a Mask
//
unsigned int NSEventMaskFromType(NSEventType type)
{
	return 0;
}
