/*
 * File: XslNumberFormat
 *
 * $Id: XslNumberFormat.java,v 1.4 1999/01/08 14:47:50 ttaylor Exp $
 */

package org.mitre.tjt.xsl;

public class XslNumberFormat {
  public XslNumberFormat() {
  		//{{INIT_CONTROLS
		//}}
}

  public static String format(int[] counts, String format) {
    StringBuffer buf = new StringBuffer();
    XslFormatToken formatTok = XslFormatToken.parseFormat(format);

    for(int x = 0; x < counts.length; x++) {
      buf.append(formatTok.format(counts[x]));
      formatTok = formatTok.nextToken();
    }
    
    // Print any post separator that was specified in the format template
    buf.append(formatTok.getPostSeparator());
    return buf.toString();
  }

  public static void main(String args[]) {
    if(args.length < 2) {
      System.out.println("Usage: java XslNumberFormat format_str count_1 count_2 ...");
      System.exit(0);
    }

    String formatStr = args[0];
    int counts[] = new int[args.length - 1];
    for(int x = 1; x < args.length; x++) {
      counts[x - 1] = Integer.parseInt(args[x]);
    }

    System.out.println("\"" + format(counts, formatStr) + "\"");
  }
	//{{DECLARE_CONTROLS
	//}}
}
