/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.List;
import org.w3c.dom.Node;

/**
 * A implementation of the "translate" function call
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class Translate extends FunctionCall {
    
    /**
     * Creates a new Translate FunctionCall
    **/
    public Translate() {
        super(Names.TRANSLATE_FN);
    } //-- Translate
    
    /**
     * Evalutes this FunctionCall using the given Node as
     * the context. This method will always return a StringResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        List params = getParameterList();
        
        if (params.size() != 3)
            throw new InvalidExprException(INVALID_NUMBER_PARAMS+this);
            
        ExprResult r1 = ((Expr)params.get(0)).evaluate(context, ps);
        ExprResult r2 = ((Expr)params.get(1)).evaluate(context, ps);
        ExprResult r3 = ((Expr)params.get(2)).evaluate(context, ps);
        
        String str1 = StringExpr.toStringResult(r1).getValue();
        String str2 = StringExpr.toStringResult(r2).getValue();
        String str3 = StringExpr.toStringResult(r3).getValue();
            
        StringBuffer result = new StringBuffer();
        
        char[] xchars = str1.toCharArray();
        
        for (int i = 0; i < xchars.length; i++) {
            int idx = str2.indexOf(xchars[i]);
            if (idx >= 0) {
                char nchar = str3.charAt(idx);
                if (nchar != -1) xchars[i] = nchar;
            }
        }
        
        return new StringResult( new String(xchars));
    } //-- evaluate
    
} //-- Translate

