/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * Represents an IdentityExpr
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class IdentityExpr implements NodeExpr {
    
      //----------------/
     //- Constructors -/
    //----------------/
    
    
    public IdentityExpr() {
        super();
    } //-- IdentityExpr
    
      //------------------/
     //- Public Methods -/
    //------------------/
    
    
    /**
     * Returns the String representation of this NodeExpr
    **/
    public String toString() {
        return ".";
    } //-- toString
    
    /**
     * Evaluates this Expr using the given context Node and ProcessorState
     * @param context the current context Node
     * @param ps the ProcessorState that contains the current processing 
     * environment
     * @return the ExprResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps)
        throws InvalidExprException 
    {
        if (context != null) {
            NodeSet nodeSet = new NodeSet(1);
            nodeSet.add(context);
            return nodeSet;
        }
        else return new NodeSet(0);
        
    } //-- evaluate
    
    public short getExprType() { return Expr.NODE_SET; }
        
    /**
     * Returns the type of this NodeExpr
     * @return the type of this NodeExpr
    **/
    public short getNodeExprType() { return NodeExpr.IDENTITY_EXPR; }
    
    
    /**
     * Determines if the given node is matched by this NodeExpr
     * within the given context
    **/
    public boolean matches(Node node, Node context, ProcessorState ps)
        throws InvalidExprException
    {
        return (node == context);
    } //-- matches
    
} //-- IdentityExpr