/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NumberResult;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.functions.FunctionCall;
import org.w3c.dom.Node;

public class NumberFunctionCall
extends FunctionCall {
    public static final short NUMBER = 0;
    public static final short ROUND = 1;
    public static final short FLOOR = 2;
    public static final short CEILING = 3;
    short functionType = 0;

    public NumberFunctionCall() {
        super("number");
    }

    public NumberFunctionCall(short s) {
        super(NumberFunctionCall.getFunctionName(s));
        this.functionType = s;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        List list = super.getParameterList();
        if (list.size() != 1) {
            throw new InvalidExprException("invalid number of parameters for function: " + this);
        }
        Expr expr = (Expr)list.get(0);
        if (expr != null) {
            double d = expr.evaluate(node, processorState).numberValue();
            switch (this.functionType) {
                case 2: {
                    d = Math.floor(d);
                    break;
                }
                case 1: {
                    d = Math.round(d);
                    break;
                }
                case 3: {
                    d = Math.ceil(d);
                    break;
                }
            }
            return new NumberResult(d);
        }
        return new NumberResult(Double.NaN);
    }

    private static String getFunctionName(short s) {
        switch (s) {
            case 2: {
                return "floor";
            }
            case 1: {
                return "round";
            }
            case 3: {
                return "ceiling";
            }
        }
        return "number";
    }
}

