/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.ExpressionParser;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.PathExpr;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.UnionExpr;
import com.kvisco.xsl.XSLException;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.XSLStylesheet;
import com.kvisco.xsl.functions.ErrorFunctionCall;
import org.w3c.dom.Node;

public class TemplateRule
extends XSLObject {
    private UnionExpr unionExpr = null;
    private String templateName = null;
    private ErrorFunctionCall errorCall = null;
    private boolean allowParamVars = true;

    public TemplateRule(XSLStylesheet xSLStylesheet) {
        super(xSLStylesheet, (short)33);
    }

    public float calculatePriority(Node node, ProcessorState processorState) {
        String string = this.getAttribute("priority");
        if (string != null && string.length() > 0) {
            try {
                return Float.valueOf(string).floatValue();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.unionExpr == null) {
            return -2.0f;
        }
        try {
            PathExpr pathExpr = this.unionExpr.getMatchingExpr(node, node, processorState);
            return pathExpr.getDefaultPriority();
        }
        catch (InvalidExprException invalidExprException) {
            return -2.0f;
        }
    }

    public XSLObject copy() {
        TemplateRule templateRule = null;
        templateRule = new TemplateRule(this.getParentStylesheet());
        templateRule.setName(this.templateName);
        templateRule.copyActions(this);
        templateRule.copyAttributes(this);
        return templateRule;
    }

    public UnionExpr getMatchExpr() {
        return this.unionExpr;
    }

    public PathExpr getMatchingExpr(Node node, Node node2, ProcessorState processorState) throws InvalidExprException {
        return this.unionExpr.getMatchingExpr(node, node2, processorState);
    }

    public String getMode() {
        return this.getAttribute("mode");
    }

    public String getName() {
        return this.templateName;
    }

    protected boolean handleAction(XSLObject xSLObject) {
        if (xSLObject == null) {
            return true;
        }
        switch (xSLObject.getType()) {
            case 27: {
                if (this.allowParamVars) break;
                return true;
            }
            default: {
                this.allowParamVars = false;
            }
        }
        return false;
    }

    public boolean matches(Node node, Node node2, ProcessorState processorState) throws InvalidExprException {
        if (this.errorCall != null) {
            this.errorCall.evaluate(node, processorState);
        }
        if (this.unionExpr == null) {
            return false;
        }
        return this.unionExpr.matches(node, node2, processorState);
    }

    public void setAttribute(String string, String string2) throws XSLException {
        if ("match".equals(string)) {
            try {
                this.unionExpr = ExpressionParser.createUnionExpr(string2);
            }
            catch (InvalidExprException invalidExprException) {
                ErrorFunctionCall errorFunctionCall = new ErrorFunctionCall();
                errorFunctionCall.setError("invalid 'match' attribute: " + string2);
                this.errorCall = errorFunctionCall;
            }
        }
        super.setAttribute(string, string2);
    }

    public void setMatchAttr(String string) {
        if (string == null) {
            string = "";
        }
        try {
            this.setAttribute("match", string);
        }
        catch (XSLException xSLException) {}
    }

    public void setModeAttr(String string) {
        try {
            this.setAttribute("mode", string);
        }
        catch (XSLException xSLException) {}
    }

    public void setName(String string) {
        this.templateName = string;
        if (this.unionExpr == null) {
            this.unionExpr = new UnionExpr();
        }
    }

    public void setPriority(float f) {
        try {
            this.setAttribute("priority", String.valueOf(f));
        }
        catch (XSLException xSLException) {}
    }
}

