/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NumberResult;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringResult;
import org.w3c.dom.Node;

public class PrimaryExpr
implements Expr {
    public static final short VARIABLE_REFERENCE = 0;
    public static final short EXPR = 1;
    public static final short LITERAL = 2;
    public static final short NUMBER = 3;
    public static final short FUNCTION_CALL = 4;
    private Expr expr = null;
    private String literal = null;
    private double number = Double.NaN;
    private short type = (short)2;

    protected PrimaryExpr(String string) {
        this.literal = string;
    }

    protected PrimaryExpr(short s) {
        this.type = s;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        switch (this.type) {
            case 0: {
                ExprResult exprResult = processorState.getVariable(this.literal);
                if (exprResult == null) break;
                return exprResult;
            }
            case 2: {
                return new StringResult(this.literal);
            }
            case 1: {
                if (this.expr == null) break;
                return this.expr.evaluate(node, processorState);
            }
            case 3: {
                return new NumberResult(this.number);
            }
            case 4: {
                if (this.expr == null) break;
                return this.expr.evaluate(node, processorState);
            }
        }
        return new StringResult("undefined");
    }

    public short getExprType() {
        return 0;
    }

    public String getLiteral() {
        return this.literal;
    }

    public double getNumber() {
        return this.number;
    }

    public short getType() {
        return this.type;
    }

    protected void setExpr(Expr expr) {
        this.expr = expr;
    }

    protected void setLiteral(String string) {
        this.literal = string;
    }

    protected void setNumber(double d) {
        this.number = d;
    }

    protected void setNumber(String string) {
        try {
            this.number = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.number = Double.NaN;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                stringBuffer.append("$");
                stringBuffer.append(this.literal);
                break;
            }
            case 2: {
                stringBuffer.append("'");
                stringBuffer.append(this.literal);
                stringBuffer.append("'");
                break;
            }
            case 1: {
                stringBuffer.append("(");
                if (this.expr != null) {
                    stringBuffer.append(this.expr.toString());
                }
                stringBuffer.append(")");
                break;
            }
            case 3: {
                stringBuffer.append(String.valueOf(this.number));
                break;
            }
            case 4: {
                if (this.expr != null) {
                    stringBuffer.append(this.expr.toString());
                    break;
                }
                stringBuffer.append("void()");
                break;
            }
        }
        return stringBuffer.toString();
    }
}

