/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.StringResult;
import com.kvisco.xsl.XSLObject;
import org.w3c.dom.Node;

public class NodeSet
implements ExprResult {
    private int DEFAULT_SIZE;
    private Node[] elements;
    private int initialSize;
    private int elementCount;

    public NodeSet() {
        this.initialSize = this.DEFAULT_SIZE = 25;
        this.elementCount = 0;
        this.elements = new Node[this.DEFAULT_SIZE];
    }

    public NodeSet(int n) {
        this.initialSize = this.DEFAULT_SIZE = 25;
        this.elementCount = 0;
        this.initialSize = n;
        this.elements = new Node[n];
    }

    public boolean add(int n, Node node) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(node)) {
            return false;
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        if (n == this.elementCount) {
            this.elements[this.elementCount++] = node;
        } else {
            this.shiftUp(n);
            this.elements[n] = node;
            ++this.elementCount;
        }
        return true;
    }

    public void add(NodeSet nodeSet) {
        int n = nodeSet.size();
        this.ensureSize(n);
        int n2 = 0;
        while (n2 < n) {
            this.add(nodeSet.get(n2));
            ++n2;
        }
    }

    public boolean add(Node node) {
        if (!this.contains(node)) {
            if (this.elementCount == this.elements.length) {
                this.increaseSize();
            }
            this.elements[this.elementCount++] = node;
            return true;
        }
        return false;
    }

    protected void arrayCopyFrom(Node[] nodeArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 1) {
            return;
        }
        this.ensureSize(n3);
        System.arraycopy(nodeArray, n, this.elements, this.elementCount, n3);
        this.elementCount += n3;
    }

    protected void arrayCopyTo(Node[] nodeArray, int n) {
        System.arraycopy(this.elements, 0, nodeArray, n, this.elementCount);
    }

    public boolean booleanValue() {
        return this.size() > 0;
    }

    public void clear() {
        int n = 0;
        while (n < this.elementCount) {
            this.elements[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public boolean contains(Node node) {
        return this.indexOf(node) >= 0;
    }

    public NodeSet copy() {
        NodeSet nodeSet = new NodeSet(this.elementCount);
        nodeSet.arrayCopyFrom(this.elements, 0, this.elementCount);
        return nodeSet;
    }

    private void ensureSize(int n) {
        int n2 = this.elements.length - this.elementCount;
        if (n2 < n) {
            int n3 = n - n2;
            Node[] nodeArray = this.elements;
            int n4 = this.elements.length + n3;
            this.elements = new Node[n4];
            System.arraycopy(nodeArray, 0, this.elements, 0, nodeArray.length);
        }
    }

    public boolean equals(ExprResult exprResult) {
        if (exprResult.getResultType() == 2) {
            return this.equals((Object)exprResult);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof NodeSet)) {
            return false;
        }
        NodeSet nodeSet = (NodeSet)object;
        if (nodeSet.size() != this.size()) {
            return false;
        }
        int n = 0;
        if (n < this.size()) {
            Node node = this.get(n);
            if (!nodeSet.contains(this.get(n))) {
                return false;
            }
            return false;
        }
        return true;
    }

    public Node get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[n];
    }

    public short getResultType() {
        return 2;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elementCount) {
            Node node = this.elements[n2];
            n += node == null ? 0 : node.hashCode();
            ++n2;
        }
        return n;
    }

    private void increaseSize() {
        Node[] nodeArray = this.elements;
        int n = nodeArray.length > 0 ? nodeArray.length : 1;
        this.elements = new Node[n * 2];
        System.arraycopy(nodeArray, 0, this.elements, 0, nodeArray.length);
    }

    public int indexOf(Node node) {
        int n = 0;
        while (n < this.elementCount) {
            if (node == this.elements[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public double numberValue() {
        if (this.size() > 0) {
            StringResult stringResult = new StringResult(XSLObject.getNodeValue(this.get(0)));
            return stringResult.numberValue();
        }
        return Double.NaN;
    }

    public Node remove(int n) {
        if (n < 0 || n > this.elementCount) {
            return null;
        }
        Node node = this.elements[n];
        this.shiftDown(n + 1);
        --this.elementCount;
        return node;
    }

    public boolean remove(Node node) {
        int n = this.indexOf(node);
        if (n <= -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    private void shiftDown(int n) {
        if (n <= 0 || n >= this.elementCount) {
            return;
        }
        System.arraycopy(this.elements, n, this.elements, n - 1, this.elementCount - n);
        this.elements[this.elementCount - 1] = null;
    }

    private void shiftUp(int n) {
        if (n == this.elementCount) {
            return;
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        System.arraycopy(this.elements, n, this.elements, n + 1, this.elementCount - n);
    }

    public int size() {
        return this.elementCount;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[this.elementCount];
        System.arraycopy(this.elements, 0, nodeArray, 0, this.elementCount);
        return nodeArray;
    }

    public Node[] toArray(Node[] nodeArray) {
        Node[] nodeArray2 = null;
        nodeArray2 = nodeArray.length >= this.elementCount ? nodeArray : new Node[this.elementCount];
        System.arraycopy(this.elements, 0, nodeArray2, 0, this.elementCount);
        return nodeArray2;
    }

    public Object toJavaObject() {
        return this;
    }
}

