/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExpressionParser;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.PrimaryExpr;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringExpr;
import com.kvisco.xsl.StringResult;
import org.w3c.dom.Node;

public class AttributeValueTemplate {
    private static final String END_EXPR = "}";
    private static final String START_EXPR = "{";
    private List components = new List();

    public AttributeValueTemplate() {
    }

    public AttributeValueTemplate(String string) throws InvalidExprException {
        this();
        if (string != null) {
            this.parse(string);
        }
    }

    public void addExpr(Expr expr) {
        this.components.add(expr);
    }

    public String evaluate(Node node, ProcessorState processorState) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            while (n < this.components.size()) {
                Expr expr = (Expr)this.components.get(n);
                StringResult stringResult = null;
                stringResult = StringExpr.toStringResult(expr.evaluate(node, processorState));
                stringBuffer.append(stringResult.toString());
                ++n;
            }
        }
        catch (InvalidExprException invalidExprException) {}
        return stringBuffer.toString();
    }

    private void parse(String string) throws InvalidExprException {
        char[] cArray = string.toCharArray();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        char c = '\"';
        char c2 = '\u0000';
        while (n < cArray.length) {
            char c3 = cArray[n++];
            if (bl2 && c3 != c) {
                stringBuffer.append(c3);
                c2 = c3;
                continue;
            }
            switch (c3) {
                case '\"': 
                case '\'': {
                    stringBuffer.append(c3);
                    if (bl2) {
                        bl2 = false;
                        break;
                    }
                    bl2 = true;
                    c = c3;
                    break;
                }
                case '{': {
                    if (!bl) {
                        if (stringBuffer.length() > 0) {
                            this.addExpr(new PrimaryExpr(stringBuffer.toString()));
                            stringBuffer.setLength(0);
                        }
                        bl = true;
                        break;
                    }
                    if (c2 == c3) {
                        bl = false;
                        stringBuffer.append(c3);
                        break;
                    }
                    stringBuffer.append(c3);
                    c3 = '\u0000';
                    break;
                }
                case '}': {
                    if (bl) {
                        bl = false;
                        this.addExpr(ExpressionParser.createExpr(stringBuffer.toString()));
                        stringBuffer.setLength(0);
                        c3 = '\u0000';
                        break;
                    }
                    if (c2 != c3) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append('}');
                            break;
                        }
                        this.addExpr(new PrimaryExpr(END_EXPR));
                        break;
                    }
                    c3 = '\u0000';
                    break;
                }
                default: {
                    stringBuffer.append(c3);
                }
            }
            c2 = c3;
        }
        if (stringBuffer.length() > 0) {
            if (bl) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("#error evaluating AttributeValueTemplate. ");
                stringBuffer2.append("Missing '}' after: ");
                stringBuffer2.append(stringBuffer.toString());
                this.addExpr(new PrimaryExpr(stringBuffer2.toString()));
            } else {
                this.addExpr(new PrimaryExpr(stringBuffer.toString()));
            }
        }
    }

    public void removeExpr(Expr expr) {
        this.components.remove(expr);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.components.size()) {
            Expr expr = (Expr)this.components.get(n);
            stringBuffer.append(expr.toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

