/**
 * The contents of this file are subject to the OpenXML Public
 * License Version 1.0; you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.openxml.org/license/
 *
 * THIS SOFTWARE AND DOCUMENTATION IS PROVIDED ON AN "AS IS" BASIS
 * WITHOUT WARRANTY OF ANY KIND EITHER EXPRESSED OR IMPLIED,
 * INCLUDING AND WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE
 * AND DOCUMENTATION IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGING. SEE THE LICENSE FOR THE
 * SPECIFIC LANGUAGE GOVERNING RIGHTS AND LIMITATIONS UNDER THE
 * LICENSE.
 *
 * The Initial Developer of this code under the License is
 * OpenXML.org. Portions created by OpenXML.org and/or Assaf Arkin
 * are Copyright (C) 1998, 1999 OpenXML.org. All Rights Reserved.
 */


package examples.changelog;


import java.io.*;
import java.util.*;
import org.w3c.dom.*;
import org.w3c.dom.fi.*;
import org.openxml.source.*;
import org.openxml.x3p.*;
import org.openxml.x3p.processors.*;
import org.openxml.dom.iterator.*;
import org.openxml.DOMFactory;
import org.openxml.util.Log;


/**
 * @version $Revision: 1.3 $ $Date: 1999/04/12 06:07:59 $
 * @author <a href="mailto:arkin@trendline.co.il">Assaf Arkin</a>
 */
public class ChangeLogProcessor
{


    public void setBeforeDate( Date before )
    {
        _ctx.setObject( "changelog.filter.before-date", before );
    }


    public void setAfterDate( Date after )
    {
        _ctx.setObject( "changelog.filter.after-date", after );
    }


    public void setReleaseDate( Date release )
    {
        _ctx.setObject( "changelog.filter.date", release );
    }


    public void setReleaseVesrion( String release )
    {
        _ctx.setObject( "changelog.filter.version", release );
    }


    public void setItemTypes( String types )
    {
        _ctx.setObject( "changelog.filter.types", types );
    }


    public void setTemplate( String uri )
    {
        _ctx.setObject( "changelog.formatter.template", uri );
    }


    public Document process( Document source )
        throws ProcessorException
    {
        _processor.process( source );
        return (Document) _ctx.getObject( "changelog.formatter.output" );
    }


    public ChangeLogProcessor()
        throws ProcessorException
    {
        ProcessorEngineCreator[]    creators;
        ProcessorEngineCreator      rpCreator;

        creators = new ProcessorEngineCreator[ 3 ];
        creators[ 0 ] = ProcessorFactory.findEngineCreator( "SSI" );
        creators[ 1 ] = EngineCreatorFromClass.fromClass( ChangeLogFilter.class );
        creators[ 2 ] = EngineCreatorFromClass.fromClass( ChangeLogFormatter.class );
        rpCreator = new ChainProcessorCreator( creators );
        ProcessorFactory.registerEngine( "ChangeLogProcessor", rpCreator );
        _processor = ProcessorFactory.createProcessor( this, "ChangeLogProcessor" );
        _ctx = _processor.getContext();
    }


    private Processor           _processor;


    private ProcessContext      _ctx;


    public static void main( String args[] )
    {
        Source              source;
        Document            document;
        ChangeLogProcessor  proc;
        OutputStream        output;
        Publisher           publisher;

        try
        {
            source = DOMFactory.newSource();
            if ( args.length > 0 )
                source.setURI( args[ 0 ] );
            else
                source.setURI( SOURCE_URI );
            System.out.println( "ChangeLogProcessor: Reading source from " + source.getURI() );
            document = source.getDocument();
            proc = new ChangeLogProcessor();
            if ( args.length > 1 )
            {
                proc.setTemplate( args[ 1 ] );
                System.out.println( "ChangeLogProcessor: Setting formatter to " + args[1] );
            }
            else
            {
                proc.setTemplate( TEMPLATE_URI );
                System.out.println( "ChangeLogProcessor: Setting formatter to " + TEMPLATE_URI );
            }
            document = proc.process( document );
            if ( args.length > 2 )
            {
                output = new FileOutputStream( args[ 2 ] );
                System.out.println( "ChangeLogProcessor: Writing results to " + args[ 2 ] );
            }
            else
            {
                output = new FileOutputStream( TARGET_URI );
                System.out.println( "ChangeLogProcessor: Writing results to" + TARGET_URI );
            }
            publisher = PublisherFactory.createPublisher( output, STREAM_FORMAT );
            publisher.publish( document );
            publisher.close();
        }
        catch ( Exception except )
        {
            Log.error( except );
        }
    }


    public static final String         SOURCE_URI = "res:/src/changelog.xml";


    public static final String         TEMPLATE_URI = "res:/examples/changelog/template.html";


    public static final String         TARGET_URI = "changelog.html";


    public static final StreamFormat   STREAM_FORMAT = StreamFormat.HTML;


}


