/**
 * The contents of this file are subject to the OpenXML Public
 * License Version 1.0; you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.openxml.org/license/
 *
 * THIS SOFTWARE AND DOCUMENTATION IS PROVIDED ON AN "AS IS" BASIS
 * WITHOUT WARRANTY OF ANY KIND EITHER EXPRESSED OR IMPLIED,
 * INCLUDING AND WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE
 * AND DOCUMENTATION IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGING. SEE THE LICENSE FOR THE
 * SPECIFIC LANGUAGE GOVERNING RIGHTS AND LIMITATIONS UNDER THE
 * LICENSE.
 *
 * The Initial Developer of this code under the License is
 * OpenXML.org. Portions created by OpenXML.org and/or Assaf Arkin
 * are Copyright (C) 1998, 1999 OpenXML.org. All Rights Reserved.
 */


package examples.changelog;


import java.util.*;
import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.fi.*;
import org.openxml.DOMFactory;
import org.openxml.x3p.*;
import org.openxml.source.*;


/**
 * @version $Revision: 1.2 $ $Date: 1999/04/12 06:07:59 $
 * @author <a href="mailto:arkin@trendline.co.il">Assaf Arkin</a>
 */
public class ChangeLogFilter
    implements ProcessorEngine
{


    public ChangeLogFilter( ProcessContext ctx )
    {
        Object      filter;
        Source      source;
        Document    filterDoc = null;

        filter = ctx.getObject( "changelog.filter.external" );
        if ( filter != null )
        {
            if ( filter instanceof Document )
                filterDoc = (Document) filter;
            else
            if ( filter instanceof Source )
                filterDoc = ( (Source) filter ).getDocument(); // .getReadOnly();
            else
            if ( filter instanceof String )
            {
                source = DOMFactory.newSource();
                source.setURI( (String) filter );
                filterDoc = ( (Source) filter ).getDocument(); // .getReadOnly();
            }
            if ( filterDoc != null )
            {
                //
                //
            }
        }

        filter = ctx.getObject( "changelog.filter.date" );
        if ( filter != null && filter instanceof String )
        {
            _releaseAfter = new Date( Date.parse( (String) filter ) );
            _releaseBefore = _releaseAfter;
        }
        else
        if ( filter != null && filter instanceof Date )
        {
            _releaseAfter = (Date) filter;
            _releaseBefore = (Date) filter;
        }

        filter = ctx.getObject( "changelog.filter.before-date" );
        if ( filter != null && filter instanceof String )
            _releaseBefore = new Date( Date.parse( (String) filter ) );
        else
        if ( filter != null && filter instanceof Date )
            _releaseBefore = (Date) filter;

        filter = ctx.getObject( "changelog.filter.after-date" );
        if ( filter != null && filter instanceof String )
            _releaseAfter = new Date( Date.parse( (String) filter ) );
        else
        if ( filter != null && filter instanceof Date )
            _releaseAfter = (Date) filter;

        filter = ctx.getObject( "changelog.filter.version" );
        if ( filter != null && filter instanceof Number )
            _releaseVersion = ( (Number) filter ).toString();
        else
        if ( filter != null && filter instanceof String )
            _releaseVersion = (String) filter;

        filter = ctx.getObject( "changelog.filter.types" );
        if ( filter != null && ! ( filter instanceof String ) )
            ctx.setObject( "changelog.filter.types", null );
    }


    public int whatToProcess()
    {
        return PROCESS_ELEMENT;
    }


    public Node process( ProcessContext ctx, Node node )
        throws ProcessorException
    {
        Date    date;
        String  version;
        String  type;
        Element elem;

        if ( node.getNodeType() == Node.ELEMENT_NODE )
        {
            elem = (Element) node;
            if ( elem.getNodeName().equals( "release" ) )
            {
                if ( _releaseAfter != null || _releaseBefore != null )
                {
                    date = new Date( Date.parse( elem.getAttribute( "date" ) ) );
                    if ( ( _releaseAfter != null && date.before( _releaseAfter ) ) ||
                         ( _releaseBefore != null && date.after( _releaseBefore ) ) )
                        return null;
                }
                if ( _releaseVersion != null )
                {
                    version = elem.getAttribute( "version" );
                    if ( ! version.equalsIgnoreCase( _releaseVersion ) )
                        return null;
                }
            }
            else


            if ( elem.getTagName().equals( "fix" ) || elem.getTagName().equals( "change" ) ||
                 elem.getTagName().equals( "new" ) || elem.getTagName().equals( "dead" ) )
            {
            }

        }
        return node;
    }


    public void destroy( ProcessContext ctx )
    {
    }


    private Date        _releaseAfter;


    private Date        _releaseBefore;


    private String      _releaseVersion;


}
