/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p.publishers;

import java.io.IOException;
import org.openxml.dom.ext.DocumentTypeEx;
import org.openxml.x3p.publishers.StreamPublisher;
import org.openxml.x3p.publishers.StreamPublisherTarget;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLStreamPublisher
extends StreamPublisher {
    XMLStreamPublisher(StreamPublisherTarget streamPublisherTarget) throws IOException {
        super(streamPublisherTarget);
    }

    protected String getCharacterRef(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    protected void printElement(Element element, StringBuffer stringBuffer, boolean bl) throws IOException {
        stringBuffer.append("<").append(element.getTagName());
        this.printPart(stringBuffer);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            this.printSpace();
            stringBuffer.setLength(0);
            stringBuffer.append(attr.getName());
            stringBuffer.append("=\"");
            if (attr.getValue() != null) {
                stringBuffer.append(this.encode(attr.getValue(), false));
            }
            stringBuffer.append('\"');
            this.printPart(stringBuffer);
            ++n;
        }
        if (element.hasChildNodes()) {
            this.printPart(">");
            this.indent();
            Node node = element.getFirstChild();
            boolean bl2 = true;
            boolean bl3 = false;
            while (node != null) {
                if (node instanceof Element) {
                    if (this.getFormat().isPretty() && bl2) {
                        this.breakLine();
                        bl3 = true;
                        this.printNode(node, bl);
                        this.breakLine();
                    } else {
                        this.printNode(node, bl);
                    }
                    bl2 = true;
                } else if (this.printNode(node, bl)) {
                    bl2 = true;
                    bl3 = true;
                }
                node = node.getNextSibling();
            }
            if (bl2 && bl3) {
                this.breakLine();
            }
            stringBuffer.setLength(0);
            this.unindent();
            stringBuffer.append("</").append(element.getTagName()).append('>');
            this.printPart(stringBuffer);
        } else {
            this.printPart("/>");
        }
    }

    public synchronized void publish(Document document) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("<?xml version=\"1.0\"");
        if (this.getEncoding() != null) {
            stringBuffer.append(" encoding=\"").append(this.getEncoding()).append('\"');
        }
        if (this.getFormat().isStandalone()) {
            stringBuffer.append(" standalone=\"yes\"");
        }
        this.printPart(stringBuffer.append("?>"));
        this.breakLine();
        DocumentType documentType = document.getDoctype();
        if (documentType != null && documentType instanceof DocumentTypeEx) {
            DocumentTypeEx documentTypeEx = (DocumentTypeEx)((Object)documentType);
            string2 = documentTypeEx.getPublicId();
            string3 = documentTypeEx.getSystemId();
            string = documentTypeEx.internalAsText();
        }
        if (this.getFormat().getInternalDTD() != null) {
            string = this.getFormat().getInternalDTD();
        }
        if (this.getFormat().getDTDPublicId() != null || this.getFormat().getDTDSystemId() != null) {
            string2 = this.getFormat().getDTDPublicId();
            string3 = this.getFormat().getDTDSystemId();
        }
        if (string2 != null || string3 != null || string != null) {
            stringBuffer.setLength(0);
            stringBuffer.append("<!DOCTYPE ").append(documentType.getNodeName());
            if (!this.getFormat().isStandalone()) {
                if (string2 != null) {
                    stringBuffer.append(" PUBLIC ");
                    this.appendLiteral(stringBuffer, string2);
                    stringBuffer.append(" ");
                    this.appendLiteral(stringBuffer, string3);
                } else if (string3 != null) {
                    stringBuffer.append(" SYSTEM ");
                    this.appendLiteral(stringBuffer, string3);
                }
            }
            if (string != null) {
                this.printPart(stringBuffer.append(" ["));
                this.indent();
                if (!this.getFormat().isCompact()) {
                    this.breakLine();
                }
                this.printPart(string);
                this.unindent();
                if (!this.getFormat().isCompact()) {
                    this.breakLine();
                }
                this.printPart("]>");
            } else {
                this.printPart(stringBuffer.append('>'));
            }
            this.breakLine();
        }
        this.publish((Node)document);
        this.flush();
    }
}

