/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p.publishers;

import java.io.IOException;
import org.openxml.util.Resources;
import org.openxml.x3p.Publisher;
import org.openxml.x3p.PublisherCreator;
import org.openxml.x3p.PublisherTarget;
import org.openxml.x3p.StreamFormat;
import org.openxml.x3p.publishers.HTMLStreamPublisher;
import org.openxml.x3p.publishers.StreamPublisher;
import org.openxml.x3p.publishers.StreamPublisherTarget;
import org.openxml.x3p.publishers.XHTMLStreamPublisher;
import org.openxml.x3p.publishers.XMLStreamPublisher;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;

public final class StreamPublisherCreator
implements PublisherCreator,
Publisher {
    private StreamPublisherTarget _target;
    private StreamPublisher _lastPublisher;
    private static final Class[] TARGETS = new Class[]{class$org$openxml$x3p$publishers$StreamPublisherTarget != null ? class$org$openxml$x3p$publishers$StreamPublisherTarget : (class$org$openxml$x3p$publishers$StreamPublisherTarget = StreamPublisherCreator.class$("org.openxml.x3p.publishers.StreamPublisherTarget"))};
    static /* synthetic */ Class class$org$openxml$x3p$publishers$StreamPublisherTarget;

    public StreamPublisherCreator() {
    }

    private StreamPublisherCreator(StreamPublisherTarget streamPublisherTarget) {
        this._target = streamPublisherTarget;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized void close() {
        if (this._target == null) {
            throw new IllegalStateException(Resources.message("Error006"));
        }
        if (this._lastPublisher != null) {
            this._lastPublisher.close();
        }
    }

    public Publisher createPublisher(PublisherTarget publisherTarget) throws IOException {
        if (!(publisherTarget instanceof StreamPublisherTarget)) {
            throw new IllegalArgumentException(Resources.format("Error003", "target"));
        }
        StreamPublisherTarget streamPublisherTarget = (StreamPublisherTarget)publisherTarget;
        if (streamPublisherTarget.getFormat() != null) {
            if (streamPublisherTarget.getFormat().isXML()) {
                return new XMLStreamPublisher(streamPublisherTarget);
            }
            if (streamPublisherTarget.getFormat().isHTML()) {
                return new HTMLStreamPublisher(streamPublisherTarget);
            }
            if (streamPublisherTarget.getFormat().isXHTML()) {
                return new XHTMLStreamPublisher(streamPublisherTarget);
            }
        }
        return new StreamPublisherCreator(streamPublisherTarget);
    }

    public boolean isSupported(PublisherTarget publisherTarget) {
        return publisherTarget instanceof StreamPublisherTarget;
    }

    public Class[] listTargets() {
        return TARGETS;
    }

    public synchronized void publish(Document document) throws IOException {
        if (this._target == null) {
            throw new IllegalStateException(Resources.message("Error006"));
        }
        this._lastPublisher = document instanceof HTMLDocument ? new XHTMLStreamPublisher(this._target.useStreamFormat(StreamFormat.XHTML)) : new XMLStreamPublisher(this._target.useStreamFormat(StreamFormat.XML));
        this._lastPublisher.publish(document);
    }

    public synchronized void publish(Node node) throws IOException {
        if (this._target == null) {
            throw new IllegalStateException(Resources.message("Error006"));
        }
        this._lastPublisher = node instanceof HTMLElement ? new XHTMLStreamPublisher(this._target.useStreamFormat(StreamFormat.XHTML)) : new XMLStreamPublisher(this._target.useStreamFormat(StreamFormat.XML));
        this._lastPublisher.publish(node);
    }
}

