/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.source.holders;

import java.util.Hashtable;
import java.util.Vector;
import org.openxml.source.Holder;
import org.openxml.source.HolderFactory;
import org.openxml.source.HolderFinder;
import org.openxml.source.Source;
import org.openxml.source.XCatalog;
import org.openxml.source.holders.FileHolderFactoryImpl;
import org.openxml.source.holders.JARHolderFactoryImpl;
import org.openxml.source.holders.ResHolderFactoryImpl;
import org.openxml.source.holders.URLHolderFactoryImpl;
import org.openxml.source.holders.XCatalogFactory;
import org.openxml.util.Log;

public final class HolderFinderImpl
implements HolderFinder {
    private Vector _factories = new Vector();
    private Hashtable _cache = new Hashtable();
    private static HolderFinder _finder;

    private HolderFinderImpl() {
    }

    public Holder findHolder(Source source) {
        return this.findHolder(source, false);
    }

    public synchronized Holder findHolder(Source source, boolean bl) {
        Holder holder = null;
        if (!bl) {
            holder = (Holder)this._cache.get(source.toString());
            if (holder != null && holder.hasModified()) {
                Log.debug("HolderFinder.findHolder: Source [" + source.toString() + "] has been modified -- removed from cache");
                this._cache.remove(source.toString());
                holder = null;
            } else if (holder != null) {
                Log.debug("HolderFinder.findHolder: Source [" + source.toString() + "] has been located -- returned from cache");
            }
        }
        if (holder == null) {
            int n = this._factories.size();
            while (holder == null && n-- > 0) {
                try {
                    holder = ((HolderFactory)this._factories.elementAt(n)).newHolder(source);
                }
                catch (Exception exception) {
                    Log.debug("HolderFinder.findHolder: Exception occured looking for holder");
                    Log.debug(exception);
                }
            }
            if (holder != null) {
                if (holder.canCache()) {
                    this._cache.put(source.toString(), holder);
                    Log.debug("HolderFinder.findHolder: Source [" + source.toString() + "] has been located -- cached and holder returned");
                } else {
                    Log.debug("HolderFinder.findHolder: Source [" + source.toString() + "] has been located -- holder returned");
                }
            } else {
                Log.debug("HolderFinder.findHolder: Source [" + source.toString() + "] could not be located");
            }
        }
        return holder;
    }

    public static HolderFinder getHolderFinder() {
        if (_finder == null) {
            _finder = new HolderFinderImpl();
            _finder.registerFactory(new URLHolderFactoryImpl());
            _finder.registerFactory(new FileHolderFactoryImpl());
            _finder.registerFactory(new ResHolderFactoryImpl());
            _finder.registerFactory(new JARHolderFactoryImpl());
        }
        return _finder;
    }

    public synchronized void registerFactory(HolderFactory holderFactory) {
        if (!this._factories.contains(holderFactory)) {
            this._factories.addElement(holderFactory);
        }
    }

    public synchronized void useCatalog(String string) {
        XCatalog xCatalog = XCatalogFactory.findCatalog(string);
        if (xCatalog != null) {
            this.registerFactory(XCatalogFactory.asHolderFactory(xCatalog));
        }
    }
}

