/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.openxml.XMLDocument;
import org.openxml.XMLElement;
import org.openxml.XMLElementFactory;
import org.openxml.dom.AttrImpl;
import org.openxml.dom.CDATASectionImpl;
import org.openxml.dom.CommentImpl;
import org.openxml.dom.DOMExceptionImpl;
import org.openxml.dom.DocumentFragmentImpl;
import org.openxml.dom.DocumentTypeImpl;
import org.openxml.dom.EntityReferenceImpl;
import org.openxml.dom.NodeImpl;
import org.openxml.dom.ProcessingInstructionImpl;
import org.openxml.dom.TextImpl;
import org.openxml.dom.iterator.ElementTagFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements Document,
DOMImplementation {
    private DocumentTypeImpl _docType;
    private Thread _lockThread;
    private int _lockCount;
    private Hashtable _elementTypes;
    private XMLElementFactory _elementFactory;
    private static final Class[] _elemClassSig = new Class[]{class$org$openxml$XMLDocument != null ? class$org$openxml$XMLDocument : (class$org$openxml$XMLDocument = DocumentImpl.class$("org.openxml.XMLDocument")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DocumentImpl.class$("java.lang.String"))};
    static /* synthetic */ Class class$org$openxml$XMLDocument;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public DocumentImpl() {
        super(null, "#document", null, false);
        this._ownerDocument = this;
    }

    protected DocumentImpl(String string) {
        super(null, string != null ? string : "", null, string != null);
        this._ownerDocument = this;
    }

    public void acquire(long l) throws RuntimeException {
        DocumentImpl documentImpl = this;
        synchronized (documentImpl) {
            try {
                if (this._lockThread != Thread.currentThread() && this._lockThread != null) {
                    long l2 = System.currentTimeMillis();
                    while (this._lockThread != null && l > System.currentTimeMillis() - l2) {
                        if (!this._lockThread.isAlive()) {
                            this._lockThread = null;
                            continue;
                        }
                        this.wait(l - System.currentTimeMillis() - l2);
                    }
                    if (this._lockThread != null) {
                        throw new RuntimeException("Timeout waiting for lock to be released.");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Timeout waiting for lock to be released.");
            }
        }
    }

    public void assignDoctype(DocumentTypeImpl documentTypeImpl) {
        if (documentTypeImpl == null) {
            throw new NullPointerException("Argument 'docType' is null.");
        }
        if (this._docType != null) {
            throw new IllegalStateException("Document type already assigned to this document.");
        }
        this._docType = documentTypeImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        DocumentImpl documentImpl = new DocumentImpl();
        this.cloneInto(documentImpl, true);
        return documentImpl;
    }

    protected synchronized void cloneInto(NodeImpl nodeImpl, boolean bl) {
        super.cloneInto(nodeImpl, bl);
        if (bl) {
            if (this._docType != null) {
                ((DocumentImpl)nodeImpl)._docType = (DocumentTypeImpl)this._docType.clone();
            }
            if (this._elementTypes != null) {
                ((DocumentImpl)nodeImpl)._elementTypes = (Hashtable)this._elementTypes.clone();
            }
        } else {
            ((DocumentImpl)nodeImpl)._docType = this._docType;
            ((DocumentImpl)nodeImpl)._elementTypes = this._elementTypes;
        }
        ((DocumentImpl)nodeImpl)._elementFactory = this._elementFactory;
    }

    public Node cloneNode(boolean bl) {
        DocumentImpl documentImpl = new DocumentImpl();
        this.cloneInto(documentImpl, bl);
        return documentImpl;
    }

    public final Attr createAttribute(String string) throws DOMException {
        return new AttrImpl(this, string, "");
    }

    public final Attr createAttribute(String string, String string2) throws DOMException {
        return new AttrImpl(this, string, string2 == null ? "" : string2);
    }

    public final CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public final Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public final DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String string) throws DOMException {
        Class clazz;
        XMLElement xMLElement;
        if (this._elementFactory != null && (xMLElement = this._elementFactory.createElement((XMLDocument)this, string)) != null) {
            return xMLElement;
        }
        if (this._elementTypes != null && (clazz = (Class)this._elementTypes.get(string)) != null) {
            try {
                Constructor constructor = clazz.getConstructor(_elemClassSig);
                return (Element)constructor.newInstance(this, string);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Tag '" + string + "' associated with an Element class that failed to construct.");
            }
        }
        return new XMLElement((Document)this, string);
    }

    public final EntityReference createEntityReference(String string) throws DOMException {
        return new EntityReferenceImpl(this, string);
    }

    public final ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public final Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public synchronized boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Object object2 = object;
        synchronized (object2) {
            DocumentImpl documentImpl = (DocumentImpl)object;
            boolean bl = this._docType == null && documentImpl._docType == null || this._docType != null && documentImpl._docType != null && this._docType.equals(documentImpl._docType);
            Object var5_5 = null;
            return bl;
        }
    }

    public final DocumentType getDoctype() {
        return this._docType;
    }

    public Element getDocumentElement() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public final NodeList getElementsByTagName(String string) {
        return (NodeList)((Object)this.createTreeIterator(2, ElementTagFilter.lookup(string)));
    }

    public final DOMImplementation getImplementation() {
        return this;
    }

    public short getNodeType() {
        return 9;
    }

    public boolean hasFeature(String string, String string2) {
        if (string2 != null && string2.indexOf("1.0") < 0 && string2.indexOf("Level 1") < 0) {
            return false;
        }
        return string != null && (string.equalsIgnoreCase("XML") || string.equalsIgnoreCase("HTML"));
    }

    public void lock() throws RuntimeException {
        DocumentImpl documentImpl = this;
        synchronized (documentImpl) {
            if (this._lockThread == Thread.currentThread()) {
                ++this._lockCount;
            } else {
                this.acquire(Long.MAX_VALUE);
                this._lockThread = Thread.currentThread();
                ++this._lockCount;
            }
        }
    }

    public void registerElement(String string, Class clazz) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Argument 'tagName' is null or an empty string.");
        }
        if (clazz == null || clazz.isAssignableFrom(class$org$w3c$dom$Element != null ? class$org$w3c$dom$Element : (class$org$w3c$dom$Element = DocumentImpl.class$("org.w3c.dom.Element")))) {
            throw new IllegalArgumentException("Argument 'elementClass' is null or does not extend Element.");
        }
        if (this._elementTypes == null) {
            this._elementTypes = new Hashtable();
        }
        this._elementTypes.put(string, clazz);
    }

    public final void setNodeValue(String string) {
        throw new DOMExceptionImpl(6, "This node type does not support values.");
    }

    protected final boolean supportsChildern() {
        return true;
    }

    public String toString() {
        return "Document: ";
    }

    public void unlock() {
        if (this._lockThread == Thread.currentThread()) {
            DocumentImpl documentImpl = this;
            synchronized (documentImpl) {
                --this._lockCount;
                if (this._lockCount == 0) {
                    this._lockThread = null;
                    this.notify();
                }
            }
        }
    }

    public void useElementFactory(XMLElementFactory xMLElementFactory) {
        if (xMLElementFactory != this) {
            this._elementFactory = xMLElementFactory;
        }
    }
}

