package com.jtauber.fop.apps;

// FOP
import com.jtauber.fop.fo.FOTreeBuilder;
import com.jtauber.fop.render.Renderer;

// SAX
import org.xml.sax.Parser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

// Java
import java.io.PrintWriter;
import java.io.IOException;

/**
 * A FOProcessor that takes a SAX Parser and InputSource and parses
 * the incoming representing of the formatting object tree.
 * 
 * Instantiate this class with a SAX Parser and InputSource and then
 * run the format method with a PrintWriter the PDF is to be given to.
 */
public class SAXProcessor extends FOProcessor {
    
    protected Parser parser;
    protected InputSource source;
	
    /**
     * create a SAX-driven FOProcessor to use the default renderer.
     *
     * @param parser the SAX parser to use
     * @param source the InputSource to parse
     */
    public SAXProcessor(Parser parser, InputSource source) {
	super(); // setup the FOProcessor
	this.parser = parser;
	this.source = source;
    }

    /**
     * create a SAX-driven FOProcessor.
     *
     * @param parser the SAX parser to use
     * @param source the InputSource to parse
     * @param renderer the renderer to use
     */
    public SAXProcessor(Parser parser, InputSource source,
			Renderer renderer) { 
        super(renderer); // setup the FOProcessor
	this.parser = parser;
	this.source = source;
    }

    /**
     * Format the document and render it
     *
     * @param writer the PrintWriter to render to
     */
    public void format(PrintWriter writer) throws FOPException {
	this.parser.setDocumentHandler(this.treeBuilder);
	try {
	    this.parser.parse(this.source);
	} catch (SAXException e) {
	    if (e.getException() instanceof FOPException)
		throw (FOPException)e.getException();
	    else
		throw new FOPException(e.getMessage());
	} catch (IOException e) {
	    throw new FOPException(e.getMessage());
	}
	layoutput(writer);
    }
}
