/*
 * timer.S
 * 
 * Timer routines for Choose-OS
 * 
 * Copyright (c) Tuomo Valkonen 1996-1997.
 */

start_time:	.word		0
old_sec:	.byte	0

set_timer:
	xor	ah,ah			! Get time...
	int	#0x1a
	mov	start_time,dx

	ret

// Read timer value and print time
////////////////////////////////////
read_timer:
	xor	ah,ah
	int	#0x1a
	mov	ax,dx
	xor	dx,dx
	cmp	ax,start_time
	jae	cont1
	neg	ax
cont1:
	sub	ax,start_time
	mov	cx,#18
	div	cx

	mov	cl,chos_delay
	sub	cl,al
	mov	al,cl
	cmp	al,#0
	jle	timeout
	cmp	al,old_sec
	je	timer_done

	call	print_timer

timer_done:
	ret
timeout:
	xor	ax,ax
	ret


// Print time
///////////////
print_timer:
	mov	old_sec,al
	xor	ah,ah
	push	ax			! move cursor
	mov	dl,chos_timex		! #0
	mov	dh,chos_timey		! chos_images \add dh,#FIRST_ROW+1
	call	set_cursor_pos
	pop	ax

	push	ax
	mov	si,#0			! si is used to test if the num is first 0

	mov	cx,#100			! print time
	div	cl
	push	ax
	cmp	al,#0
	je	first_is0
	add	al,#48
	mov	si,#1			! '0'
first_is0:
	call	putch
	pop	ax

	shr	ax,#8			
	mov	cx,#10
	div	cl
	push	ax
	cmp	si,#1
	je	second_mustnt_be0
	cmp	al,#0
	je	second_is0
second_mustnt_be0:
	add	al,#48			! '0'
	mov	si,#1
second_is0:
	call	putch
	pop	ax
	
	shr	ax,#8			
	add	al,#48			! '0'				
	call	putch
	
	pop	ax
	ret
