//<copyright>
//
// Copyright (c) 1994-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name :       mthumb.C
//
// Purpose :    Implementation of class MThumb
//
// Created :    12 Apr 94    Bernhard Marschall
//
// $Id: mthumb.C,v 1.1 1996/03/12 16:54:59 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: mthumb.C,v $
// Revision 1.1  1996/03/12 16:54:59  bmarsch
// Initial revision
//
// Revision 1.2  1996/02/16 09:01:49  bmarsch
// Erased unnecessary include
//


#include <stdio.h>
#include <iostream.h>

#include <InterViews/canvas.h>
#include <InterViews/color.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
//#include <IV-look/bevel.h>
#include <IV-look/kit.h>

#include "mthumb.h"


MThumb::MThumb(const TelltaleFlags s, DimensionName dim)
: Glyph()
{
  // save dimension and telltalestates
  dimension_ = dim;
  flags_ = s;

  // init colors
  Display* dpy = Session::instance()->default_display();
  active_color_ = Color::lookup(dpy, "gray40");
  Resource::ref(active_color_);
  inactive_color_ = Color::lookup(dpy, "black");
  Resource::ref(inactive_color_);
}

MThumb::~MThumb()
{
  // free colors
  Resource::unref(active_color_);
  Resource::unref(inactive_color_);
}


void MThumb::allocate(Canvas* c, const Allocation& a, Extension& ext) {
  ext.merge(c, a);
}

void MThumb::draw(Canvas* canvas, const Allocation& a) const {
  const Color* color;
  if ((flags_ & TelltaleState::is_visible) != 0)
    color = active_color_;
  else
    color = inactive_color_;

  Coord x0 = a.left();
  Coord y0 = a.bottom();
  Coord x1 = a.right();
  Coord y1 = a.top();

  canvas->fill_rect(x0, y0, x1, y1, color);
}
