// -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name: KbdHandler.h
//
// Purpose:
//
// Created: 3.10.94   Gaisbauer Mansuet Juergen
//
// $Id: kbdhandler.h,v 1.1 1996/02/05 15:56:15 bmarsch Exp $
//
//
// Description:
//
//</file>
//
// $Log: kbdhandler.h,v $
// Revision 1.1  1996/02/05 15:56:15  bmarsch
// Initial revision
//

#ifndef __KbdHandler_h__
#define __KbdHandler_h__

#include <hyperg/utils/list.h>

#include <InterViews/monoglyph.h>
#include <InterViews/resource.h>
#include <InterViews/action.h>
#include <InterViews/handler.h>

class Style;
class Canvas;
class Allocation;
class Event;
class Hit;

//<class>
//
// Name: KeyFunction
//
// Purpose: Represenataion of a keystroke and an action to call
//
// Public Interface:
//
//  - KeyFunction(
//         unsigned int mask,     mask for the modifier keys (X11)
//         unsigned long sym,     keyboard symbol (X11)
//         Action* action         action to call
//         ) 
//
// Description:
//
//</class>

class KeyFunction : public DLListNode, public Handler {
public:
  KeyFunction(unsigned int mask, unsigned long sym, Action* action) 
  : keymask_(mask), keysym_(sym), action_(action)
  {
    Resource::ref(action_);
  }
  ~KeyFunction() { Resource::unref(action_); }

  virtual boolean event(Event& e);

  unsigned int keymask_;
  unsigned long keysym_;
  Action* action_;
};

DLListdeclare(KeyFunctionList, KeyFunction)

//<class>
//
// Name: KeyboardHandler
//
// Purpose: Glyph to handle keyboard events
//
// Public Interface:
//
//  - KeyboardHandler(Glyph* g)
//    g is glyph to add keyboard functionality.
//
//  - ~KeyboardHandler()
//
//  - void pick(Canvas*, const Allocation&, int depth, Hit&)
//    an action is only executed if the event is inside the body glyph.
//
//  - const KeyFunctionList& getFunctionList()
//    returns the list of defined keyboard functions
//
//  - void appendFunction(KeyFunction* func)
//    adds a function to the list.
//
//  - void removeFunction(KeyFunction* func)
//    removes a function from the list.
//
//  - void removeAllFunctions()
//    removes all defined functions.
//
// Description:
//
//</class>

class KeyboardHandler : public MonoGlyph {
public:
  KeyboardHandler(Glyph* g);
  ~KeyboardHandler();

  virtual void pick(Canvas*, const Allocation&, int depth, Hit&);

  const KeyFunctionList& getFunctionList() { return function_list_; }
  void appendFunction(KeyFunction* func);
  void removeFunction(KeyFunction* func);
  void removeAllFunctions();

private:
  KeyFunctionList function_list_;
};

#endif
