/*
 * Copyright (C) 1992 by Software Research Associates, Inc.
 *	Author:	Y. Kawabe <kawabe@sra.co.jp>
 *
 * Permission to use, copy, modify, and distribute, and sell this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Software Research Associates
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#ifndef iv_fontset_h
#define iv_fontset_h

#include <InterViews/boolean.h>
#include <InterViews/coord.h>
#include <InterViews/resource.h>
#include <NLS/enter-scope.h>
//#include <OS/enter-scope.h>

#include <InterViews/_enter.h>

class WChar;
class Font;
class FontBoundingBox;
class FontSetImpl;
class FontSetImplTable;
class FontSetPool;
class FontSetRepTable;
class String;

/*
 * class FontSetRep
 */

class FontSetRep {
  public:
    FontSetRep (const String&, int mask);
    ~FontSetRep ();

  public:
    const String& name() const;
    int mask() const;

  public:
    int convert (int) const;

  private:
    String		*name_;
    int                 mask_;

  public:
    static const FontSetRep* Find (CharSet_T, int);

  private:
    static FontSetRepTable	*table_;
};

inline const String& FontSetRep::name() const { return *name_; }
inline int FontSetRep::mask() const { return mask_; }
inline int FontSetRep::convert (int c) const { return c | mask_; }

/*
 * class FontSet
 */

class FontSet : public Resource {
  public:
    FontSet();
    FontSet(const String& basename);
    FontSet(const char* basename);
    FontSet(const FontSet&);
    ~FontSet();

  public:
    static const FontSet* lookup(const String&);
    static const FontSet* lookup(const char*);

  public:
    const char* name () const;

  public:
    const Font* Find(CharSet_T, const FontSetRep*&) const;
    const Font* Find(const String& encoding) const;
    const Font* Find(const char* encoding) const;
    void Insert (const String &);
    void Insert (const Font*);
    void Remove (const Font*);

  public:
    virtual Coord ascent() const;
    virtual Coord descent() const;
    virtual Coord width(const WChar&) const;
    virtual Coord width(const WChar*, int) const;
    virtual void char_bbox(const WChar&, FontBoundingBox&) const;
    virtual void string_bbox(const WChar*, int, FontBoundingBox&) const;
    virtual int index(const WChar*, int, Coord offset, boolean between) const;

  public:
    /* anachronisms */
    int Baseline() const;
    int Height() const;
    int Width(const WChar*, int) const;

  private:
    FontSetImplTable	*table_;
    char		*name_;
    Coord		ascent_;
    Coord		descent_; 

  protected:
    static FontSetPool	*pool_;
};

#include <InterViews/_leave.h>

#endif
