// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1997
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiorpchdr.h
// 
// Purpose:     
// 
// Created:     20 Feb 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tiorpchdr.h,v 1.1 1997/02/20 19:32:25 jfasch Exp $
// 
// $Log: tiorpchdr.h,v $
// Revision 1.1  1997/02/20 19:32:25  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tiorpchdr_h
#define hg_dispatch_tiorpchdr_h

#include "libdispatch.h"

#include "enter-scope.h"

class TIOrpcstream;

// Insert or extract this header to send or receive a RPC request.

class TIORpcHdr {
public:
    TIORpcHdr(void* writer, int request);
    TIORpcHdr();

    unsigned long reader();
    int request();
    int ndata();
protected:
    friend TIOrpcstream& operator>>(TIOrpcstream&, TIORpcHdr&);
    friend TIOrpcstream& operator<<(TIOrpcstream&, const TIORpcHdr&);
protected:
    union {
	void* _writer;		// stores writer sending this RPC request
	unsigned long _reader;	// maps to reader for this RPC request
    };
    int _request;		// maps to member function to be called
    int _ndata;			// gives size (in bytes) of data to extract
};

// Get information about the RPC request.

inline unsigned long TIORpcHdr::reader() {
    return _reader;
}

inline int TIORpcHdr::request() {
    return _request;
}

inline int TIORpcHdr::ndata() {
    return _ndata;
}

#endif
