// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tioinetsrc_p.C
// 
// Purpose:     
// 
// Created:     18 Jun 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tioinetsrc_p.C,v 1.4 1997/02/12 23:13:11 jfasch Exp $
// 
// $Log: tioinetsrc_p.C,v $
// Revision 1.4  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.3  1996/10/03 12:02:50  jfasch
// verbose.h and assert.h moved
//
// Revision 1.2  1996/07/22 08:18:19  jfasch
// *** empty log message ***
//
// Revision 1.1  1996/07/08 13:16:36  jfasch
// Initial revision
//
// 
// </file> 
#include "tioinetsrc_p.h"

#include "dispatcher.h"
#include "tsockio.h"

#include <hyperg/utils/assert.h>
#include <hyperg/utils/new.h>

// --------------------------------------------------------------------
bool TIOSourcePassive_INET :: start_() {
   if (port_.listen (portno_)) {
      Dispatcher::instance().link (port_.fd(), Dispatcher::ReadMask, this) ;
      return true ;
   }
   else 
      return false ;
}

void TIOSourcePassive_INET :: stop_() {
   if (port_) {
      Dispatcher::instance().unlink (port_.fd(), Dispatcher::ReadMask) ;
      port_.close() ;
   }
}

int TIOSourcePassive_INET :: inputReady (int fd) {
   hgassert (fd==port_.fd(), "TIOSourcePassive_INET::inputReady(): not my fd") ;
   INETSocketPtr s ;
   if (! port_.accept (s))
      error_() ;
   else 
      ready_(TransparentIOPtr (HGNEW (TransparentSocketIO (SocketPtr(s.ptr()))))) ;
   return 0 ;
}
