// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  Filename.C

  Stephane Rehel
  April 12 1997
*/

#include "Filename.h"
#include "ListFiles.h"

/////////////////////////////////////////////////////////////////////////////

Filename::Filename()
{
  path= "";
  filename= "";
  extension= "";
}

/////////////////////////////////////////////////////////////////////////////

Filename::Filename( const OString& fullname )
{
  OString fn;
  Filename::split( fullname, path, fn );

  // now, fn does not contain any '/' char

  extension= "";

  int i= fn.length()-1;
  while( i >= 0 )
    {
    if( fn[i] == '.' )
      {
      // ok
      extension= fn.getLast(i);
      break;
      }
    --i;
    }

  filename= fn.getFirst( fn.length() - extension.length() );
}

/////////////////////////////////////////////////////////////////////////////

IBOOL Filename::isAbsolute() const
{
  return path.isAbsolute();
}

/////////////////////////////////////////////////////////////////////////////

// split a complete filename
// We always have: fullname = path + filename
// Ex:
//    fullname = "/home/foousr/boo.c"
//    -> path = "/home/foousr/"
//       filename= "boo.c"
// Ex:
//    fullname = "/home/foousr/"
//    -> path = "/home/foousr/"
//       filename= ""
// Ex:
//    fullname = "/home/foousr"
//    -> path = "/home/"
//       filename= "foousr"
// Ex:
//    fullname = "boo.c"
//    -> path = ""
//       filename= "boo.c"

// static
void Filename::split( const OString& fullname,
                      Path& path, OString& filename )
{
  int i= fullname.length() - 1;

  while( i >= 0 )
    {
    if( fullname[i] == Path::separator )
      break;
    --i;
    }

  path= fullname.getFirst( i+1 );
  filename= fullname.getLast( i+1 );
}

/////////////////////////////////////////////////////////////////////////////

// if error, return FALSE
IBOOL Filename::operator == ( const Filename& _file2 ) const
{
  if( &_file2 == this )
    return ITRUE;

  OString file1= (*this).get();
  OString file2= _file2.get();

  if( file1 == file2 )
    return ITRUE;

  return ListFiles::sameFile(file1,file2);
}

/////////////////////////////////////////////////////////////////////////////
