// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  OOClass.h

  Stephane Rehel

  December 2 1997
*/

#ifndef __OOClass_h
#define __OOClass_h

#ifndef __IBOOL_h
#include "tools/IBOOL.h"
#endif

#ifndef __OString_h
#include "tools/OString.h"
#endif

#ifndef __SIList_h
#include "tools/SIList.h"
#endif

#ifndef __IVector_h
#include "tools/IVector.h"
#endif

#ifndef __OOComponent_h
#include "OOComponent.h"
#endif

class OOPackage;
class OORelation;

/////////////////////////////////////////////////////////////////////////////

class OOClass: public OOComponent
{
protected:
  OOPackage* package;

  OString name;

  // connected relations
  SIList<OORelation> relations;

public:
  struct
    {
    int x1, y1, x2, y2;
    } draw;

public:
  OOClass( OOPackage* _package, const OString& _name );

  virtual ~OOClass();

  const OString& getName() const
    {
    return name;
    }

  IBOOL connected( OORelation* relation );

  void connect( OORelation* r );
  void unconnect( OORelation* r );

  IVector getConnectionNormal( double s ) const;
  IPoint getConnectionPoint( double s ) const;
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __OOClass_h
