// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLFDelete.C

  Stephane Rehel
  August 2 1997
*/

#include "MLFDelete.h"

#include "tools/IntegerArray.h"

#include "model/ModelModule.h"
#include "model/ModelModes.h"
#include "model/ModelCommand.h"
#include "model/ModelCommands.h"
#include "model/ModelFlags.h"

#include "model/modes/MLMSelect.h"

/////////////////////////////////////////////////////////////////////////////

MLFDelete::MLFDelete( MLModule* _module ):
  MLBaseFunction(_module)
{}

/////////////////////////////////////////////////////////////////////////////

MLFDelete::~MLFDelete()
{}

/////////////////////////////////////////////////////////////////////////////

IBOOL MLFDelete::_call()
{
  module->enterMode(ModelModes::SELECT);

  ModelModule* model= (ModelModule*) module;

  if( model->getFlags()->singleSelection )
    model->pushMessage( "Select object to delete" );
   else
    model->pushMessage( "Select object(s) to delete" );

  while( ! exitFunction )
    {
    if( ! interfaceYield() )
      break;

    MLMSelect* s= (MLMSelect*) model->getMode(ModelModes::SELECT);
    if( s == 0 )
      break;
    if( s->objects.getSize() == 0 )
      continue;

    ModelCommand* cmd= new ModelCommand;
    cmd->type= ModelCommands::DELETE;
    cmd->indices= s->objects;

    if( model->getFlags()->singleSelection )
      cmd->indices.truncate(1);

    model->post(cmd);
    }

  model->popMessage();

  module->leaveMode();

  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////
