// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLScrollingDialog.h

  Stephane Rehel

  December 18 1996
*/

#ifndef __MLScrollingDialog_h
#define __MLScrollingDialog_h

#ifndef __OString_h
#include "tools/OString.h"
#endif

#ifndef __KWCallbackClass_h
#include "kw/KWCallbackClass.h"
#endif

#ifndef __MLAllocObject_h
#include "MLAllocObject.h"
#endif

class KWDialog;
class MLModule;

/////////////////////////////////////////////////////////////////////////////

class MLScrollingDialog: public MLAllocObject, public KWCallbackClass
{
  friend class MLScrollingDialogs;

protected:
  OString name;
  const unsigned char* data; // dialog data
  KWDialog* kwDialog;
  MLModule* mlmodule;
  unsigned int updateFlags;

public:
  MLScrollingDialog( MLModule* _mlmodule );

  virtual ~MLScrollingDialog();

  const OString& getName() const
    {
    return name;
    }

  virtual void update() = 0;

  virtual IBOOL kwCallback( KWEvent& );

  void remove();

  int getModuleID() const;

  unsigned int getUpdateFlags() const
    {
    return updateFlags;
    }

  // called just after dialog creation
  virtual void justCreated()
    {}
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLScrollingDialog_h
