// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  Interface.h

  Stephane Rehel

  July 8 1996
*/

#ifndef __Interface_h
#define __Interface_h

#ifndef __IVector_h
#include "tools/IVector.h"
#endif

#ifndef __OString_h
#include "tools/OString.h"
#endif

#ifndef __MLEventHandler_h
#include "graphics/MLEventHandler.h"
#endif

#ifndef __MLKeyboardHandler_h
#include "graphics/MLKeyboardHandler.h"
#endif

#ifndef __MLEventGrabber_h
#include "graphics/MLEventGrabber.h"
#endif

#ifndef __MLThread_h
#include "tools/thread/MLThread.h"
#endif

class OString;
class Command;
class SystemWindow;
class SoftWindow;
class MLModulesBar;
class MLModule;
class MLCanvas;
class MLEngine;
class Key;
class MLCommand;
class MLCommandList;
class MLEventManager;
class GraphicsSystem;
class MLGammaCorrection;

/////////////////////////////////////////////////////////////////////////////

// Well, there's a thread for waiting either an X event, either
// a refresh screen request (from the lighting thread)
// Our thread waits for an X event

class Interface: public MLEventHandler, public MLKeyboardHandler,
                                        public MLEventGrabber
{
  friend class MLModule;
  friend class MLModulesBar;

protected:
  OString programName;

  IVector screenSize;
  SystemWindow* window;

  int currentModule;

  int* modules;
  int nModules;

  MLModulesBar* modulesBar;

  static int buttonsPanelWidth;
  static int scrollingDialogsWidth;
  static int modulesBarHeight;
  static int statusLinesHeight;

  MLCommandList* cmdList;

  MLMutex postRefreshMutex;

  SystemWindow* exclusiveModeWindow;

public:
  Interface();
  virtual ~Interface();

  void init( Command& command );

  void post( MLCommand* command );

  void postRefreshCanvas( int canvasID );
  void postRefreshDialog( int dialogID );

  void callIdleModulesFunction();

protected:
  IBOOL last_function_must_return() const;

public:
  // check for refresh, and post refresh commands if necessary
  // return ITRUE if last_function_must_return
  IBOOL checkForRefresh();

  // get events, send commands, and return
  // return ITRUE if last_function_must_return
  IBOOL runloop();

  // constantly call runloop()
  void mainloop();

  // return ITRUE if last_function_must_return
  IBOOL sendCommands();

  IBOOL inExclusiveMode() const;
  SystemWindow* enterExclusiveMode();
  void leaveExclusiveMode();

protected:
  void handleCommand( MLCommand* cmd );

public:
  void refreshInterface();

protected:
  virtual IBOOL eventHandler( MLWindow*, MLEvent& );
  virtual IBOOL eventGrabber( MLWindow*, MLEvent& );

public:
  void newModule( int id );
  void activateModule( int id );
  MLModule* getCurrentModule() const;
  IBOOL currentModuleInFunction() const;

protected:
  virtual IBOOL handleMLKeyboard( MLEvent& event );

public:
  // used by exclusive modes
  IBOOL testIconifyingKey( const Key& key );

  MLEventManager* getEventManager() const;
  GraphicsSystem* getGraphicsSystem() const;

  IBOOL isIconic() const;
  void pushWaitCursor();
  void popWaitCursor();
  MLGammaCorrection* getGammaCorrection() const;
  double getGammaCorrectionValue() const;

private:
  void pressKey( const Key& key );
  void unpressKey( const Key& key );
};

/////////////////////////////////////////////////////////////////////////////

extern Interface* interface;

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __Interface_h
