// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "MLImage.h"

#include "pnm/MLImageReaderPNM.h"
#include "gif/MLImageReaderGIF.h"
#include "tga/MLImageReaderTGA.h"
#include "rgb/MLImageReaderRGB.h"
#include "jpg/MLImageReaderJPG.h"
#include "tif/MLImageReaderTIF.h"
#include "bmp/MLImageReaderBMP.h"

#include "pnm/MLImageWriterPNM.h"
#include "jpg/MLImageWriterJPG.h"
#include "tif/MLImageWriterTIF.h"

void toto()
{
  MLImageReader* r= 0;
  MLImageWriter* w= 0;

  r= new MLImageReaderTIF;
  OString fmt= ".tif";

//  w= new MLImageWriterPNM;
  w= new MLImageWriterPNM;

  MLImage* p1= new MLImage;
//  MLImage* p2= new MLImage;

  OString base= "toto";
  OString base1= "abc";
  OString ppmfmt= ".ppm";

  assert( r->open(base+fmt) );
  if( ! r->read(p1) )
   {
   fprintf( stderr, "%s\n",r->getError().get());
   assert(0);
   }
printf("READ OK\n");
  assert( w->open(base1+ppmfmt) );
  assert( w->write(p1) );
  w->close();

  exit(0);
}

