// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLDrawable.h

  Stephane Rehel
  July 22 1996
*/

#ifndef __MLDrawable_h
#define __MLDrawable_h

#ifndef __IBOOL_h
#include "tools/IBOOL.h"
#endif

#ifndef __IVector_h
#include "tools/IVector.h"
#endif


/////////////////////////////////////////////////////////////////////////////

class MLDrawable
{
private:
  IVector size;

public:
  MLDrawable();
  virtual ~MLDrawable();

protected:
  void createDrawable( int width, int height );

  void setDrawableSize( const IVector& newSize );

public:
  void clear( float r, float g, float b );

  // GraphicsOp
  void beginDraw();
  void endDraw();

  static IBOOL enableDrawing( IBOOL yes = ITRUE ); // return previous value
  static IBOOL disableDrawing();

  Color8 getGray0(); // black
  Color8 getGray1();
  Color8 getGray2();
  Color8 getGray3(); // white
  void gray0(); // black
  void gray1();
  void gray2();
  void gray3(); // white

  void setForeground( Color8 color );
  void setBackground( Color8 color );

  void drawLine( int x1, int y1, int x2, int y2 );
  void drawLine( const IPoint& p1, const IPoint& p2 );
  void drawHorizLine( int x1, int x2, int y );
  void drawHorizLine( const IPoint& origin, int length );
  void drawVertLine( int x, int y1, int y2 );
  void drawVertLine( const IPoint& origin, int length );

  void drawRectangle( const IPoint& p1, const IPoint& p2 );
  void drawRectangle( int x, int y, int width, int height );

  void fillRectangle( const IPoint& p1, const IPoint& p2 );
  void fillRectangle( int x, int y, int width, int height );
  void fillRectangle( const IPoint& pos, const IVector& size );
  void fillGrayRectangle( const IPoint& p1, const IPoint& p2 );
  void fillGrayRectangle2( const IPoint& p1, const IPoint& p2 );

  void fillQuad( const IPoint& p1, const IPoint& p2,
                 const IPoint& p3, const IPoint& p4 );

  void drawTriangle( const IPoint& p1, const IPoint& p2, const IPoint& p3 );
  void fillTriangle( const IPoint& p1, const IPoint& p2, const IPoint& p3 );

  void drawPressedRectangle( int width, int height );
  void drawUnpressedRectangle( int width, int height );

  void fillPressedRectangle( const IPoint& p1, const IPoint& p2,
                             Color8 bright, Color8 normal, Color8 dark,
                             int z );

  void fillUnpressedRectangle( const IPoint& p1, const IPoint& p2,
                               Color8 bright, Color8 normal, Color8 dark,
                               int z );

  // please give clockwise points
  void fillPressedTriangle( const IPoint& p1,
                            const IPoint& p2,
                            const IPoint& p3,
                            Color8 bright,
                            Color8 normal,
                            Color8 dark,
                            int z );

  // please give clockwise points
  void fillUnpressedTriangle( const IPoint& p1,
                              const IPoint& p2,
                              const IPoint& p3,
                              Color8 bright,
                              Color8 normal,
                              Color8 dark,
                              int z );

  void fillWindow( Color8 color );

  void setFont( MLFont* _font );

  MLFont* getFont() const
    {
    return font;
    }

  void drawString( int x, int y, const char* string, int length );
  void drawString( int x, int y, const char* string );
  void drawString( const IPoint& pos, const char* string );
  void drawString( const IPoint& pos, const OString& string );

  void drawImageString( int x, int y, const char* string, int length );
  void drawImageString( int x, int y, const char* string );
  void drawImageString( const IPoint& pos, const OString& string );

  int textWidth( const char* string );
  int textHeight() const;

  void drawPixmap( MLPixmap* pixmap, int x, int y );

  OString cutString( const OString& _string, int max_width ) const;
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLDrawable_h
