## This file is part of Moonlight Creator
##    Copyright (C) 1996-1998  Stephane Rehel
##
## Portions grabbed from the KDE project:
##    Copyright (C) 1997 Janos Farkas (chexum@shadow.banki.hu)
##              (C) 1997 Stephan Kulow (coolo@kde.org)
##
## This library is free software; you can redistribute it and/or
## modify it under the terms of the GNU Library General Public
## License as published by the Free Software Foundation; either
## version 2 of the License, or (at your option) any later version.
##
## This library is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## Library General Public License for more details.
##
## You should have received a copy of the GNU Library General Public
## License along with this library; if not, write to the Free
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# CHECK FOR COMPILERS

AC_DEFUN(AC_CHECK_COMPILERS,
[
  AC_ARG_ENABLE(debug,[  --enable-debug               creates debugging code [default=no]],
  [
   if test $enableval = "no"; dnl
     then ac_use_debug_code="no"
     else ac_use_debug_code="yes"
   fi
  ], [ac_use_debug_code="no"])

dnl this was AC_PROG_CC. I had to include it manualy, since I had to patch it
  AC_MSG_CHECKING(for a C-Compiler)
  dnl if there is one, print out. if not, don't matter
  AC_MSG_RESULT($CC)

  if test -z "$CC"; then AC_CHECK_PROG(CC, gcc, gcc) fi
  if test -z "$CC"; then AC_CHECK_PROG(CC, cc, cc, , , /usr/ucb/cc) fi
  if test -z "$CC"; then AC_CHECK_PROG(CC, xlc, xlc) fi
  test -z "$CC" && AC_MSG_ERROR([no acceptable cc found in \$PATH])

  AC_PROG_CC_WORKS
  AC_PROG_CC_GNU

  if test $ac_cv_prog_gcc = yes; then
    GCC=yes
  else
    GCC=
  fi

  if test -z "$GCC" ; then
    ## Yes, yes, yes, you need gcc. /KEPLER Feb.24.98
    AC_MSG_ERROR([You _need_ gcc ! Unable to find it in \$PATH])
  fi

  if test -z "$CFLAGS"; then
    if test "$ac_use_debug_code" = "yes"; then
      AC_PROG_CC_G
      if test $ac_cv_prog_cc_g = yes; then
        CFLAGS="-g"
      fi
#    else
#      if test "$GCC" = "yes"; then
#        CFLAGS="-O2"
#      else
#        CFLAGS=""
#      fi
    fi

    if test "$GCC" = "yes"; then
     CFLAGS="$CFLAGS -Wall"
    fi
  fi

  if test -z "$CFLAGS_O"; then
    if test "$GCC" = "yes"; then
      CFLAGS_O="-O2 -Wall -DNDEBUG -DNWARN -fomit-frame-pointer -fexpensive-optimizations -ffast-math -funroll-loops"
      if test "$target_cpu" = "i386" || \
         test "$target_cpu" = "i486" || \
         test "$target_cpu" = "i586" || \
         test "$target_cpu" = "i686" ; then
        CFLAGS_O="$CFLAGS_O -malign-loops=2 -malign-jumps=2 -malign-functions=2"
      fi
    else
      CFLAGS_O="-O -DNDEBUG -DNWARN"
    fi
  fi

  AC_SUBST(CFLAGS_O)

  if test -z "$LDFLAGS_O" && test "$GCC" = "yes"; then
    LDFLAGS_O="-s"
  fi

  AC_SUBST(LDFLAGS_O)

  AC_PROVIDE(AC_PROG_CC)

dnl this is AC_PROG_CPP. I had to include it here, since autoconf checks
dnl dependecies between AC_PROG_CPP and AC_PROG_CC (or is it automake?)

  AC_MSG_CHECKING(how to run the C preprocessor)
  # On Suns, sometimes $CPP names a directory.
  if test -n "$CPP" && test -d "$CPP"; then
    CPP=
  fi
  if test -z "$CPP"; then
  AC_CACHE_VAL(ac_cv_prog_CPP,
  [  # This must be in double quotes, not single quotes, because CPP may get
    # substituted into the Makefile and "${CC-cc}" will confuse make.
    CPP="${CC-cc} -E"
    # On the NeXT, cc -E runs the code through the compiler's parser,
    # not just through cpp.
    dnl Use a header file that comes with gcc, so configuring glibc
    dnl with a fresh cross-compiler works.
    AC_TRY_CPP([#include <assert.h>
    Syntax Error], ,
    CPP="${CC-cc} -E -traditional-cpp"
    AC_TRY_CPP([#include <assert.h>
    Syntax Error], , CPP=/lib/cpp))
    ac_cv_prog_CPP="$CPP"])dnl
    CPP="$ac_cv_prog_CPP"
  else
    ac_cv_prog_CPP="$CPP"
  fi
  AC_MSG_RESULT($CPP)
  AC_SUBST(CPP)dnl

  AC_PROVIDE(AC_PROG_CPP)

  AC_MSG_CHECKING(for a C++-Compiler)
  dnl if there is one, print out. if not, don't matter
  AC_MSG_RESULT($CXX)

  if test -z "$CXX"; then AC_CHECK_PROG(CXX, g++, g++) fi
  if test -z "$CXX"; then AC_CHECK_PROG(CXX, CC, CC) fi
  if test -z "$CXX"; then AC_CHECK_PROG(CXX, xlC, xlC) fi
  if test -z "$CXX"; then AC_CHECK_PROG(CXX, DCC, DCC) fi
  test -z "$CXX" && AC_MSG_ERROR([no acceptable C++-compiler found in \$PATH])

  AC_PROG_CXX_WORKS
  AC_PROG_CXX_GNU

  if test $ac_cv_prog_gxx = yes; then
    GXX=yes
  else
    AC_MSG_CHECKING(whether we are using SPARC CC)
    GXX=
    cat > conftest.C << EOF
#ifdef __SUNPRO_CC
   yes;
#endif
EOF

    ac_try="$CXX -E conftest.C"
    if { (eval echo configure:__online__: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; } | egrep yes >/dev/null 2>&1; then
      ac_cv_prog_CC=yes
    else
      ac_cv_prog_CC=no
    fi
    AC_MSG_RESULT($ac_cv_prog_CC)
  fi

  if test -z "$CXXFLAGS"; then
    if test "$ac_use_debug_code" = "yes"; then
      AC_PROG_CXX_G
      if test $ac_cv_prog_cxx_g = yes; then
        CXXFLAGS="-g"
      fi
      if test "$ac_cv_prog_CC" = "yes"; then
        CXXFLAGS="$CXXFLAGS -pto"
      fi
#    else
#      if test "$GXX" = "yes"; then
#         CXXFLAGS="-O2"
#      else
#         if test "$ac_cv_prog_CC" = "yes"; then
#            CXXFLAGS="-pto -O2"
#         else
#            CXXFLAGS=""
#         fi
#      fi
    fi

    if test "$GXX" = "yes"; then
       CXXFLAGS="$CXXFLAGS -Wall"
    else
       ## Yes, yes, yes, you need g++. /KEPLER Feb.24.98
       if test -z "$GCC" ; then
         AC_MSG_ERROR([You _need_ g++ ! Unable to find it in \$PATH])
       fi
    fi
  fi

  if test -z "$CXXFLAGS_O"; then
    if test "$GCC" = "yes"; then
      CXXFLAGS_O="$CFLAGS_O"
    else
      CXXFLAGS_O="-O -DNDEBUG -DNWARN"
    fi
  fi

  AC_SUBST(CXXFLAGS_O)

  AC_PROVIDE(AC_PROG_CXX)

#  CXX_VERSION=`$(CXX) -v 2>&1`

])

## ------------------------------------------------------------------------
## Find a file (or one of more files in a list of dirs)
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])

## ------------------------------------------------------------------------
## Find the header files and libraries for X-Windows. Extended the
## macro AC_PATH_X
## ------------------------------------------------------------------------
##
AC_DEFUN(MOONLIGHT_PATH_X,
[
AC_MSG_CHECKING(for X)
AC_CACHE_VAL(ac_cv_have_x,
[# One or both of the vars are not set, and there is no cached value.
ac_x_includes=NO ac_x_libraries=NO
AC_PATH_X_DIRECT
AC_PATH_X_XMKMF
if test "$ac_x_includes" = NO || test "$ac_x_libraries" = NO; then
  AC_MSG_ERROR([Can't find X includes. Please check your installation and add the correct paths!])
else
  # Record where we found X for the cache.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$ac_x_includes ac_x_libraries=$ac_x_libraries"
fi])dnl
eval "$ac_cv_have_x"

if test "$have_x" != yes; then
  AC_MSG_RESULT($have_x)
  no_x=yes
else
  # If each of the values was on the command line, it overrides each guess.
  test "x$x_includes" = xNONE && x_includes=$ac_x_includes
  test "x$x_libraries" = xNONE && x_libraries=$ac_x_libraries

  # don't set -I/usr/X11R6/include please. It's boring. /S.Rehel
  # IRIX test doesn't support -ef ! Aaah GNU ... Aah linux!
  #
  if test -d $x_includes/X11 ; then
    xdir1=`cd $x_includes/X11 && /bin/pwd`
  else
    xdir1=""
  fi
  if test -d /usr/include/X11 ; then
    xdir2=`cd /usr/include/X11 && /bin/pwd`
  else
    xdir2=""
  fi
  if test "$xdir1" = "$xdir2" ; then
    x_includes=/usr/include
  fi

  # Update the cache value to reflect the command line values.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$x_includes ac_x_libraries=$x_libraries"
  AC_MSG_RESULT([libraries $x_libraries, headers $x_includes])
fi

if test -z "$x_includes" || \
   test "$x_includes" = "/usr/include" || \
   test "x$x_includes" = xNONE; then
  X_INCLUDES=""
  x_includes="."; dnl better than nothing :-
 else
  X_INCLUDES="-I$x_includes"
fi

if test -z "$x_libraries" || test "$x_libraries" = xNONE; then
  X_LDFLAGS=""
  x_libraries="/usr/lib"; dnl better than nothing :-
  all_libraries=""
 else
  X_LDFLAGS="-L$x_libraries"
  all_libraries=$X_LDFLAGS
fi

AC_SUBST(X_INCLUDES)
AC_SUBST(X_LDFLAGS)
all_includes=$X_INCLUDES
])


## ------------------------------------------------------------------------
## Try to find the TTF headers and libraries.
## $(TTF_LDFLAGS) will be -Lttfliblocation (if needed)
## and $(TTF_INCLUDES) will be -Ittfhdrlocation (if needed)
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_CHECK_TTF,
[
AC_MSG_CHECKING([for FreeType])
ac_ttf_includes=NO ac_ttf_libraries=NO
ttf_libraries=""
ttf_includes=""
AC_ARG_WITH(ttf-dir,
    [  --with-ttf-dir=DIR           where the root of freetype is installed ],
    [  ac_ttf_includes="$withval"/include
       ac_ttf_libraries="$withval"/lib
    ])

AC_ARG_WITH(ttf-includes,
    [  --with-ttf-includes=DIR      where the freetype includes are. ],
    [
       ac_ttf_includes="$withval"
    ])

AC_ARG_WITH(ttf-libraries,
    [  --with-ttf-libraries=DIR     where the freetype library is installed.],
    [  ac_ttf_libraries="$withval"
    ])

if test "$ac_ttf_includes" = NO || test "$ac_ttf_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_ttf,
[#try to guess ttf locations

ttf_incdirs="$ac_ttf_includes /usr/lib/freetype/include \
 /usr/local/freetype/include /usr/include/freetype /usr/include \
 /usr/local/include /usr/local/ttf \
 ${topdir}/freetype/lib ${topdir}/freetype-1.0/lib \
 $TTF_INC"
test -n "$TTFDIR" && ttf_incdirs="$TTFDIR/include $TTFDIR $ttf_incdirs"
AC_FIND_FILE(freetype.h, $ttf_incdirs, ttf_incdir)
ac_ttf_includes=$ttf_incdir

ttf_libdirs="$ac_ttf_libraries /usr/lib/freetype/lib \
 /usr/local/freetype/lib /usr/lib/freetype /usr/lib \
 /usr/local/lib /usr/local/ttf/lib \
 ${topdir}/freetype/lib \
 ${topdir}/freetype-1.0/lib \
 $TTFLIB"
test -n "$TTFDIR" && ttf_libdirs="$TTFDIR/lib $TTFDIR $ttf_libdirs"
AC_FIND_FILE(libttf.so libttf.so.1.0.0 libttt.so.1 libttf.a libttf.sl, $ttf_libdirs, ttf_libdir)
ac_ttf_libraries=$ttf_libdir

ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS

CXXFLAGS="$CXXFLAGS -I$ttf_incdir"
LDFLAGS="-L$ttf_libdir"
LIBS="$LIBS -lttf"

AC_LANG_CPLUSPLUS
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include "freetype.h"
int main() {
  TT_Engine engine;
  TT_Init_FreeType(&engine);
  return 0;
}
EOF

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
  ac_ttf_libraries="NO"
fi
rm -f conftest*
CXXFLAGS=$ac_cxxflags_safe
LDFLAGS=$ac_ldflags_safe
LIBS=$ac_libs_safe

if test "$ac_ttf_includes" = NO || test "$ac_ttf_libraries" = NO; then
  ac_cv_have_ttf="have_ttf=no"
  ac_ttf_notfound=""
  if test "$ac_ttf_includes" = NO; then
    if test "$ac_ttf_libraries" = NO; then
      ac_ttf_notfound="(headers and libraries)";
    else
      ac_ttf_notfound="(headers)";
    fi
  else
    ac_ttf_notfound="(libraries)";
  fi

  AC_MSG_ERROR([FreeType $ac_ttf_notfound not found. Please check your installation! ]);
else
  have_ttf="yes"
fi
])
else
  have_ttf="yes"
fi

eval "$ac_cv_have_ttf"

if test "$have_ttf" != yes; then
  AC_MSG_RESULT([$have_ttf]);
else
  ac_cv_have_ttf="have_ttf=yes \
    ac_ttf_includes=$ac_ttf_includes ac_ttf_libraries=$ac_ttf_libraries"
  AC_MSG_RESULT([libraries $ac_ttf_libraries, headers $ac_ttf_includes])

  ttf_libraries=$ac_ttf_libraries
  ttf_includes=$ac_ttf_includes
fi

AC_SUBST(ttf_libraries)
AC_SUBST(ttf_includes)

if test "$ttf_includes" = "$x_includes" || \
   test "$ttf_includes" = "/usr/include" || \
   test "$ttf_includes" = "/usr/local/include" || \
   test -z "$ttf_includes"; then
 TTF_INCLUDES="";
else
 TTF_INCLUDES="-I$ttf_includes"
 all_includes="$TTF_INCLUDES $all_includes"
fi

if test "$ttf_libraries" = "$x_libraries" || \
   test "$ttf_libraries" = "/usr/lib" || \
   test "$ttf_libraries" = "/usr/local/lib" || \
   test -z "$ttf_libraries"; then
 TTF_LDFLAGS="-lttf"
else
 TTF_LDFLAGS="-L$ttf_libraries -lttf"
 all_libraries="$TTF_LDFLAGS $all_libraries"
fi

AC_SUBST(TTF_INCLUDES)
AC_SUBST(TTF_LDFLAGS)
])

## ------------------------------------------------------------------------
## Try to find the GL/MesaGL headers and libraries.
## Try to find the GLU/MesaGLU headers and libraries.
## ------------------------------------------------------------------------

AC_DEFUN(AC_CHECK_GL,
[
AC_MSG_CHECKING([for GL])
ac_gl_includes=NO
ac_gl_libraries=NO
gl_libraries=""
gl_includes=""
AC_ARG_WITH(gl-dir,
    [  --with-gl-dir=DIR            where the root of OpenGL is installed ],
    [  ac_gl_includes="$withval"/include
       ac_gl_libraries="$withval"/lib
    ])

AC_ARG_WITH(gl-includes,
    [  --with-gl-includes=DIR       where the OpenGL includes are. ],
    [
       ac_gl_includes="$withval"
    ])

AC_ARG_WITH(gl-libraries,
    [  --with-gl-libraries=DIR      where the OpenGL library is installed.],
    [  ac_gl_libraries="$withval"
    ])

if test "$ac_gl_includes" = NO || test "$ac_gl_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_gl,
[#try to guess gl locations

gl_incdirs="$ac_gl_includes \
            /usr/include \
            /usr/local/include \
            /usr/local/Mesa/include \
            $HOME/Mesa/include \
            ${topdir}/Mesa/include \
            $GL_INC"
test -n "$GLDIR" && gl_incdirs="$GLDIR/include $GLDIR $gl_incdirs"
AC_FIND_FILE(GL/gl.h, $gl_incdirs, gl_incdir)
ac_gl_includes=$gl_incdir

gl_libdirs="$ac_gl_libraries \
            /usr/lib \
            /usr/local/lib \
            /usr/local/Mesa/lib \
            $HOME/Mesa/lib \
            ${topdir}/Mesa/lib \
            $GLLIB"
test -n "$GLDIR" && gl_libdirs="$GLDIR/lib $GLDIR $gl_libdirs"

GL_LIBNAME=""
AC_FIND_FILE(libGL.so libGL.a, $gl_libdirs, gl_libdir)
if test "$gl_libdir" = NO ; then
  AC_FIND_FILE(libMesaGL.so libMesaGL.a, $gl_libdirs, gl_libdir)
  ac_gl_libraries=$gl_libdir
  GL_LIBNAME="Mesa"
else
  ac_gl_libraries=$gl_libdir
  GL_LIBNAME=""
fi

AC_FIND_FILE(libGL.so libMesaGL.so libGL.a libMesaGL.a, $gl_libdirs, gl_libdir)
ac_gl_libraries=$gl_libdir

ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS

CXXFLAGS="$CXXFLAGS -I$gl_incdir"
LDFLAGS="-L$gl_libdir"
LIBS="-lGL $LIBS"

AC_LANG_CPLUSPLUS
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include "GL/gl.h"
int main() {
  glEnd();
  return 0;
}
EOF

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  rm -f conftest*
  LIBS="-lMesaGL $ac_libs_safe"

cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include "GL/gl.h"
int main() {
  glEnd();
  return 0;
}
EOF

  if AC_TRY_EVAL(ac_link) && test -s conftest; then
    rm -f conftest*
   else
    echo "configure: failed program was:" >&AC_FD_CC
    cat conftest.$ac_ext >&AC_FD_CC
    ac_gl_libraries="NO"
   fi
fi

rm -f conftest*
CXXFLAGS=$ac_cxxflags_safe
LDFLAGS=$ac_ldflags_safe
LIBS=$ac_libs_safe

if test "$ac_gl_includes" = NO || test "$ac_gl_libraries" = NO; then
  ac_cv_have_gl="have_gl=no"
  ac_gl_notfound=""
  if test "$ac_gl_includes" = NO; then
    if test "$ac_gl_libraries" = NO; then
      ac_gl_notfound="(headers and libraries)";
    else
      ac_gl_notfound="(headers)";
    fi
  else
    ac_gl_notfound="(libraries)";
  fi

  AC_MSG_ERROR([OpenGL $ac_gl_notfound not found. Please check your installation! ]);
else
  have_gl="yes"
fi
])
else
  have_gl="yes"
fi

eval "$ac_cv_have_gl"

if test "$have_gl" != yes; then
  AC_MSG_RESULT([$have_gl]);
else
  ac_cv_have_gl="have_gl=yes \
    ac_gl_includes=$ac_gl_includes ac_gl_libraries=$ac_gl_libraries"
  AC_MSG_RESULT([libraries $ac_gl_libraries/lib${GL_LIBNAME}GL*, headers $ac_gl_includes/GL])

  gl_libraries=$ac_gl_libraries
  gl_includes=$ac_gl_includes
fi

AC_SUBST(gl_libraries)
AC_SUBST(gl_includes)

if test "$gl_includes" = "$x_includes" || \
   test "$gl_includes" = "/usr/include" || \
   test "$gl_includes" = "/usr/local/include" || \
   test -z "$gl_includes"; then
 GL_INCLUDES="";
else
 GL_INCLUDES="-I$gl_includes"
 all_includes="$GL_INCLUDES $all_includes"
fi

if test "$gl_libraries" = "$x_libraries" || \
   test "$gl_libraries" = "/usr/lib" || \
   test "$gl_libraries" = "/usr/local/lib" || \
   test -z "$gl_libraries"; then
 GL_LDFLAGS=""
else
 GL_LDFLAGS="-L$gl_libraries"
 all_libraries="$GL_LDFLAGS $all_libraries"
fi

AC_SUBST(GL_INCLUDES)
AC_SUBST(GL_LDFLAGS)
AC_SUBST(GL_LIBNAME)
])

## ------------------------------------------------------------------------
## Try to find the GLTT headers and libraries.
## $(GLTT_LDFLAGS) will be -Lglttliblocation (if needed)
## and $(GLTT_INCLUDES) will be -Igltthdrlocation (if needed)
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_CHECK_GLTT,
[
AC_MSG_CHECKING([for gltt])
ac_gltt_includes=NO ac_gltt_libraries=NO
gltt_libraries=""
gltt_includes=""
AC_ARG_WITH(gltt-dir,
    [  --with-gltt-dir=DIR          where the root of gltt is installed ],
    [  ac_gltt_includes="$withval"
       ac_gltt_libraries="$withval"
    ])

AC_ARG_WITH(gltt-includes,
    [  --with-gltt-includes=DIR     where gltt includes are. ],
    [
       ac_gltt_includes="$withval"
    ])

AC_ARG_WITH(gltt-libraries,
    [  --with-gltt-libraries=DIR    where gltt library is installed.],
    [  ac_gltt_libraries="$withval"
    ])

if test "$ac_gltt_includes" = NO || test "$ac_gltt_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_gltt,
[#try to guess gltt locations

gltt_incdirs="$ac_gltt_includes /usr/local/include /usr/lib/gltt/include \
 /usr/local/gltt/include /usr/include/gltt /usr/include /usr/local/gltt \
 ${HOME}/gltt ${topdir}/gltt \
 $GLTT_INC"
test -n "$GLTTDIR" && gltt_incdirs="$GLTTDIR/include $GLTTDIR $gltt_incdirs"
AC_FIND_FILE(GLTTFont.h, $gltt_incdirs, gltt_incdir)
ac_gltt_includes=$gltt_incdir

gltt_libdirs="$ac_gltt_libraries /usr/local/lib /usr/lib/gltt/lib \
 /usr/local/gltt/lib /usr/lib/gltt /usr/lib /usr/local/gltt \
 ${HOME}/gltt ${topdir}/gltt \
 $GLTTLIB"
test -n "$GLTTDIR" && gltt_libdirs="$GLTTDIR/lib $GLTTDIR $gltt_libdirs"
AC_FIND_FILE(libgltt.so libgltt.so.1 libgltt.a libgltt.sl, $gltt_libdirs, gltt_libdir)
ac_gltt_libraries=$gltt_libdir

ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS

CXXFLAGS="$CXXFLAGS -I$gltt_incdir -I$gl_includes -I$ttf_includes"
LDFLAGS=""
LIBS="-L$gltt_libdir -lgltt -L$gl_libraries -l${GL_LIBNAME}GL -l${GL_LIBNAME}GLU $LIBSOCKET -L$ttf_libdir -lttf $LIBS"

AC_LANG_CPLUSPLUS
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include "GLTTFont.h"
int main() {
  GLTTFont f(0);
  f.destroy();
  return 0;
}
EOF

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
  ac_gltt_libraries="NO"
fi
rm -f conftest*
CXXFLAGS=$ac_cxxflags_safe
LDFLAGS=$ac_ldflags_safe
LIBS=$ac_libs_safe

if test "$ac_gltt_includes" = NO || test "$ac_gltt_libraries" = NO; then
  ac_cv_have_gltt="have_gltt=no"
  ac_gltt_notfound=""
  if test "$ac_gltt_includes" = NO; then
    if test "$ac_gltt_libraries" = NO; then
      ac_gltt_notfound="(headers and libraries)";
    else
      ac_gltt_notfound="(headers)";
    fi
  else
    ac_gltt_notfound="(libraries)";
  fi

  AC_MSG_ERROR([GLTT $ac_gltt_notfound not found. Please check your installation! ]);
else
  have_gltt="yes"
fi
])
else
  have_gltt="yes"
fi

eval "$ac_cv_have_gltt"

if test "$have_gltt" != yes; then
  AC_MSG_RESULT([$have_gltt]);
else
  ac_cv_have_gltt="have_gltt=yes \
    ac_gltt_includes=$ac_gltt_includes ac_gltt_libraries=$ac_gltt_libraries"
  AC_MSG_RESULT([libraries $ac_gltt_libraries, headers $ac_gltt_includes])

  gltt_libraries=$ac_gltt_libraries
  gltt_includes=$ac_gltt_includes
fi

AC_SUBST(gltt_libraries)
AC_SUBST(gltt_includes)

if test "$gltt_includes" = "/usr/include" || \
   test "$gltt_includes" = "/usr/local/include" || \
   test -z "$gltt_includes"; then
 GLTT_INCLUDES="";
else
 GLTT_INCLUDES="-I$gltt_includes"
 all_includes="$GLTT_INCLUDES $all_includes"
fi

if test "$gltt_libraries" = "/usr/lib" || \
   test "$gltt_libraries" = "/usr/local/lib" || \
   test -z "$gltt_libraries"; then
 GLTT_LDFLAGS="-lgltt"
else
 GLTT_LDFLAGS="-L$gltt_libraries -lgltt"
 all_libraries="$GLTT_LDFLAGS $all_libraries"
fi

AC_SUBST(GLTT_INCLUDES)
AC_SUBST(GLTT_LDFLAGS)
])

## ------------------------------------------------------------------------
## Try to find the ZLIB headers and libraries.
## $(ZLIB_LDFLAGS) will be -Lzlibliblocation (if needed)
## and $(ZLIB_INCLUDES) will be -Izlibhdrlocation (if needed)
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_CHECK_ZLIB,
[
AC_MSG_CHECKING([for zlib])
ac_zlib_includes=NO ac_zlib_libraries=NO
zlib_libraries=""
zlib_includes=""
AC_ARG_WITH(zlib-dir,
    [  --with-zlib-dir=DIR          where the root of zlib is installed ],
    [  ac_zlib_includes="$withval"
       ac_zlib_libraries="$withval"
    ])

AC_ARG_WITH(zlib-includes,
    [  --with-zlib-includes=DIR     where zlib includes are. ],
    [
       ac_zlib_includes="$withval"
    ])

AC_ARG_WITH(zlib-libraries,
    [  --with-zlib-libraries=DIR    where zlib library is installed.],
    [  ac_zlib_libraries="$withval"
    ])

if test "$ac_zlib_includes" = NO || test "$ac_zlib_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_zlib,
[#try to guess zlib locations

zlib_incdirs="$ac_zlib_includes /usr/local/include /usr/lib/zlib/include \
 /usr/local/zlib/include /usr/include/zlib /usr/include /usr/local/zlib \
 /usr/local/zlib-1.0.4 $HOME/zlib-1.0.4 \
 ${topdir}/zlib ${topdir}/zlib-1.0.4 \
 $ZLIB_INC"
test -n "$ZLIBDIR" && zlib_incdirs="$ZLIBDIR/include $ZLIBDIR $zlib_incdirs"
AC_FIND_FILE(zlib.h, $zlib_incdirs, zlib_incdir)
ac_zlib_includes=$zlib_incdir

zlib_libdirs="$ac_zlib_libraries /usr/local/lib /usr/lib/zlib/lib \
 /usr/local/zlib/lib /usr/lib/zlib /usr/lib /usr/local/zlib \
 /usr/local/zlib-1.0.4 $HOME/zlib-1.0.4 \
 ${topdir}/zlib ${topdir}/zlib-1.0.4 \
 $ZLIBLIB"
test -n "$ZLIBDIR" && zlib_libdirs="$ZLIBDIR/lib $ZLIBDIR $zlib_libdirs"
AC_FIND_FILE(libz.so libz.so.1.0.4 libz.so.1 libz.a libz.sl, $zlib_libdirs, zlib_libdir)
ac_zlib_libraries=$zlib_libdir

ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS

CXXFLAGS="$CXXFLAGS -I$zlib_incdir"
LDFLAGS="-L$zlib_libdir"
LIBS="$LIBS -lz"

AC_LANG_CPLUSPLUS
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include "zlib.h"
int main() {
  gzopen(0,0);
  return 0;
}
EOF

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
  ac_zlib_libraries="NO"
fi
rm -f conftest*
CXXFLAGS=$ac_cxxflags_safe
LDFLAGS=$ac_ldflags_safe
LIBS=$ac_libs_safe

if test "$ac_zlib_includes" = NO || test "$ac_zlib_libraries" = NO; then
  ac_cv_have_zlib="have_zlib=no"
  ac_zlib_notfound=""
  if test "$ac_zlib_includes" = NO; then
    if test "$ac_zlib_libraries" = NO; then
      ac_zlib_notfound="(headers and libraries)";
    else
      ac_zlib_notfound="(headers)";
    fi
  else
    ac_zlib_notfound="(libraries)";
  fi

  AC_MSG_ERROR([zlib $ac_zlib_notfound not found. Please check your installation! ]);
else
  have_zlib="yes"
fi
])
else
  have_zlib="yes"
fi

eval "$ac_cv_have_zlib"

if test "$have_zlib" != yes; then
  AC_MSG_RESULT([$have_zlib]);
else
  ac_cv_have_zlib="have_zlib=yes \
    ac_zlib_includes=$ac_zlib_includes ac_zlib_libraries=$ac_zlib_libraries"
  AC_MSG_RESULT([libraries $ac_zlib_libraries, headers $ac_zlib_includes])

  zlib_libraries=$ac_zlib_libraries
  zlib_includes=$ac_zlib_includes
fi

AC_SUBST(zlib_libraries)
AC_SUBST(zlib_includes)

if test "$zlib_includes" = "/usr/include" || \
   test "$zlib_includes" = "/usr/local/include" || \
   test -z "$zlib_includes"; then
 ZLIB_INCLUDES="";
else
 ZLIB_INCLUDES="-I$zlib_includes"
 all_includes="$ZLIB_INCLUDES $all_includes"
fi

if test "$zlib_libraries" = "/usr/lib" || \
   test "$zlib_libraries" = "/usr/local/lib" || \
   test -z "$zlib_libraries"; then
 ZLIB_LDFLAGS="-lz"
else
 ZLIB_LDFLAGS="-L$zlib_libraries -lz"
 all_libraries="$ZLIB_LDFLAGS $all_libraries"
fi

AC_SUBST(ZLIB_INCLUDES)
AC_SUBST(ZLIB_LDFLAGS)
])

## ------------------------------------------------------------------------
## Try to find the JPEG headers and libraries.
## $(JPEG_LDFLAGS) will be -Ljpegliblocation (if needed)
## and $(JPEG_INCLUDES) will be -Ijpeghdrlocation (if needed)
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_CHECK_JPEG,
[
AC_MSG_CHECKING([for jpeg])
ac_jpeg_includes=NO ac_jpeg_libraries=NO
jpeg_libraries=""
jpeg_includes=""
AC_ARG_WITH(jpeg-dir,
    [  --with-jpeg-dir=DIR          where the root of jpeg-6a is installed ],
    [  ac_jpeg_includes="$withval"
       ac_jpeg_libraries="$withval"
    ])

AC_ARG_WITH(jpeg-includes,
    [  --with-jpeg-includes=DIR     where jpeg-6a includes are. ],
    [
       ac_jpeg_includes="$withval"
    ])

AC_ARG_WITH(jpeg-libraries,
    [  --with-jpeg-libraries=DIR    where jpeg-6a library is installed.],
    [  ac_jpeg_libraries="$withval"
    ])

if test "$ac_jpeg_includes" = NO || test "$ac_jpeg_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_jpeg,
[#try to guess jpeg locations

jpeg_incdirs="$ac_jpeg_includes /usr/include /usr/local/include
 /usr/local/jpeg /usr/local/jpeg-6a \
 $HOME/jpeg-6a $HOME/jpeg \
 ${topdir}/jpeg ${topdir}/jpeg-6a \
 /usr/include/gr $JPEG_INC"
test -n "$JPEGDIR" && jpeg_incdirs="$JPEGDIR/include $JPEGDIR $jpeg_incdirs"
AC_FIND_FILE(jpeglib.h, $jpeg_incdirs, jpeg_incdir)
ac_jpeg_includes=$jpeg_incdir

jpeg_libdirs="$ac_jpeg_libraries /usr/lib /usr/local/lib
 /usr/local/jpeg /usr/local/jpeg-6a \
 $HOME/jpeg-6a $HOME/jpeg \
 ${topdir}/jpeg ${topdir}/jpeg-6a \
 $JPEGLIB"
test -n "$JPEGDIR" && jpeg_libdirs="$JPEGDIR/lib $JPEGDIR $jpeg_libdirs"
AC_FIND_FILE(libjpeg.so libjpeg.so.6.0.1 libjpeg.so.6 libjpeg.a libjpeg.sl, $jpeg_libdirs, jpeg_libdir)
ac_jpeg_libraries=$jpeg_libdir

ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS

CXXFLAGS="$CXXFLAGS -I$jpeg_incdir"
LDFLAGS="-L$jpeg_libdir"
LIBS="$LIBS -ljpeg -lm"

AC_LANG_CPLUSPLUS
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
extern "C"
{
#include <stdio.h>
#include <stdlib.h>
#include "jpeglib.h"
}
int main() {
  struct jpeg_decompress_struct jpeg_info;
  jpeg_create_decompress( &jpeg_info );
  return 0;
}
EOF

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
  ac_jpeg_libraries="NO"
fi
rm -f conftest*
CXXFLAGS=$ac_cxxflags_safe
LDFLAGS=$ac_ldflags_safe
LIBS=$ac_libs_safe

if test "$ac_jpeg_includes" = NO || test "$ac_jpeg_libraries" = NO; then
  ac_cv_have_jpeg="have_jpeg=no"
  ac_jpeg_notfound=""
  if test "$ac_jpeg_includes" = NO; then
    if test "$ac_jpeg_libraries" = NO; then
      ac_jpeg_notfound="(headers and libraries)";
    else
      ac_jpeg_notfound="(headers)";
    fi
  else
    ac_jpeg_notfound="(libraries)";
  fi

  have_jpeg="no"
else
  have_jpeg="yes"
fi
])
else
  have_jpeg="yes"
fi

eval "$ac_cv_have_jpeg"

HAS_JPEG=$have_jpeg

if test "$have_jpeg" != yes; then
  AC_MSG_RESULT([$have_jpeg]);
  AC_MSG_WARN([jpeg $ac_jpeg_notfound not found. JPEG support disabled. ]);
else
  ac_cv_have_jpeg="have_jpeg=yes \
    ac_jpeg_includes=$ac_jpeg_includes ac_jpeg_libraries=$ac_jpeg_libraries"
  AC_MSG_RESULT([libraries $ac_jpeg_libraries, headers $ac_jpeg_includes])

  jpeg_libraries=$ac_jpeg_libraries
  jpeg_includes=$ac_jpeg_includes
fi

AC_SUBST(jpeg_libraries)
AC_SUBST(jpeg_includes)

if test "$jpeg_includes" = "/usr/include" || \
   test "$jpeg_includes" = "/usr/local/include" || \
   test -z "$jpeg_includes"; then
 JPEG_INCLUDES="";
else
 JPEG_INCLUDES="-I$jpeg_includes"
 all_includes="$JPEG_INCLUDES $all_includes"
fi

if test "$jpeg_libraries" = "/usr/lib" || \
   test "$jpeg_libraries" = "/usr/local/lib" || \
   test -z "$jpeg_libraries"; then
 JPEG_LDFLAGS="-ljpeg"
else
 JPEG_LDFLAGS="-L$jpeg_libraries -ljpeg"
 all_libraries="$JPEG_LDFLAGS $all_libraries"
fi

if test "$HAS_JPEG" = "no" ; then
  JPEG_INCLUDES=""
  JPEG_LDFLAGS=""
fi

AC_SUBST(HAS_JPEG)
AC_SUBST(JPEG_INCLUDES)
AC_SUBST(JPEG_LDFLAGS)
])

## ------------------------------------------------------------------------
## Try to find the TIFF headers and libraries.
## $(TIFF_LDFLAGS) will be -Ltiffliblocation (if needed)
## and $(TIFF_INCLUDES) will be -Itiffhdrlocation (if needed)
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_CHECK_TIFF,
[
AC_MSG_CHECKING([for tiff])
ac_tiff_includes=NO ac_tiff_libraries=NO
tiff_libraries=""
tiff_includes=""
AC_ARG_WITH(tiff-dir,
    [  --with-tiff-dir=DIR          where the root of libtiff is installed ],
    [  ac_tiff_includes="$withval/libtiff"
       ac_tiff_libraries="$withval/libtiff"
    ])

AC_ARG_WITH(tiff-includes,
    [  --with-tiff-includes=DIR     where libtiff includes are. ],
    [
       ac_tiff_includes="$withval"
    ])

AC_ARG_WITH(tiff-libraries,
    [  --with-tiff-libraries=DIR    where libtiff library is installed.],
    [  ac_tiff_libraries="$withval"
    ])

if test "$ac_tiff_includes" = NO || test "$ac_tiff_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_tiff,
[#try to guess tiff locations

tiff_incdirs="$ac_tiff_includes /usr/include /usr/local/include
 /usr/local/tiff /usr/local/libtiff \
 $HOME/tiff $HOME/libtiff \
 ${topdir}/tiff ${topdir}/tiff/libtiff \
 /usr/include/gr $TIFF_INC"
test -n "$TIFFDIR" && tiff_incdirs="$TIFFDIR/include $TIFFDIR $tiff_incdirs"
AC_FIND_FILE(tiffio.h, $tiff_incdirs, tiff_incdir)
ac_tiff_includes=$tiff_incdir

tiff_libdirs="$ac_tiff_libraries /usr/lib /usr/local/lib
 /usr/local/tiff /usr/local/libtiff \
 $HOME/tiff $HOME/libtiff \
 ${topdir}/tiff ${topdir}/tiff/libtiff \
 $TIFFLIB"
test -n "$TIFFDIR" && tiff_libdirs="$TIFFDIR/lib $TIFFDIR $tiff_libdirs"
AC_FIND_FILE(libtiff.so libtiff.so.3.4.037 libtiff.so.3 libtiff.a libtiff.sl, $tiff_libdirs, tiff_libdir)
ac_tiff_libraries=$tiff_libdir

ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS

CXXFLAGS="$CXXFLAGS -I$tiff_incdir"
LDFLAGS="-L$tiff_libdir"
LIBS="$LIBS -ltiff -lm"

AC_LANG_CPLUSPLUS
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include "tiffio.h"
int main() {
  TIFF* tiff;
  tiff= TIFFOpen( "","rb" );
  return 0;
}
EOF

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
  ac_tiff_libraries="NO"
fi
rm -f conftest*
CXXFLAGS=$ac_cxxflags_safe
LDFLAGS=$ac_ldflags_safe
LIBS=$ac_libs_safe

if test "$ac_tiff_includes" = NO || test "$ac_tiff_libraries" = NO; then
  ac_cv_have_tiff="have_tiff=no"
  ac_tiff_notfound=""
  if test "$ac_tiff_includes" = NO; then
    if test "$ac_tiff_libraries" = NO; then
      ac_tiff_notfound="(headers and libraries)";
    else
      ac_tiff_notfound="(headers)";
    fi
  else
    ac_tiff_notfound="(libraries)";
  fi

  have_tiff="no"
else
  have_tiff="yes"
fi
])
else
  have_tiff="yes"
fi

eval "$ac_cv_have_tiff"

HAS_TIFF=$have_tiff

if test "$have_tiff" != yes; then
  AC_MSG_RESULT([$have_tiff]);
  AC_MSG_WARN([libtiff $ac_tiff_notfound not found. TIFF support disabled. ]);
else
  ac_cv_have_tiff="have_tiff=yes \
    ac_tiff_includes=$ac_tiff_includes ac_tiff_libraries=$ac_tiff_libraries"
  AC_MSG_RESULT([libraries $ac_tiff_libraries, headers $ac_tiff_includes])

  tiff_libraries=$ac_tiff_libraries
  tiff_includes=$ac_tiff_includes
fi

AC_SUBST(tiff_libraries)
AC_SUBST(tiff_includes)

if test "$tiff_includes" = "/usr/include" || \
   test "$tiff_includes" = "/usr/local/include" || \
   test -z "$tiff_includes"; then
 TIFF_INCLUDES="";
else
 TIFF_INCLUDES="-I$tiff_includes"
 all_includes="$TIFF_INCLUDES $all_includes"
fi

if test "$tiff_libraries" = "/usr/lib" || \
   test "$tiff_libraries" = "/usr/local/lib" || \
   test -z "$tiff_libraries"; then
 TIFF_LDFLAGS="-ltiff"
else
 TIFF_LDFLAGS="-L$tiff_libraries -ltiff"
 all_libraries="$TIFF_LDFLAGS $all_libraries"
fi

if test "$HAS_TIFF" = "no" ; then
  TIFF_INCLUDES=""
  TIFF_LDFLAGS=""
fi

AC_SUBST(HAS_TIFF)
AC_SUBST(TIFF_INCLUDES)
AC_SUBST(TIFF_LDFLAGS)
])

## ------------------------------------------------------------------------
## Try to find the PTHREADS headers and libraries.
## $(PTHREADS_LDFLAGS) will be -Lpthreadsliblocation (if needed)
## and $(PTHREADS_INCLUDES) will be -Ipthreadshdrlocation (if needed)
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_CHECK_PTHREADS,
[
AC_MSG_CHECKING([for pthreads])
ac_pthreads_includes=NO ac_pthreads_library=NO
pthreads_library=""
pthreads_includes=""

AC_ARG_WITH(pthreads-includes,
    [  --with-pthreads-includes=DIR where libpthreads includes are. ],
    [
       ac_pthreads_includes="$withval"
    ])

AC_ARG_WITH(pthreads-library,
    [  --with-pthreads-library=LIB  which pthreads library should we use?],
    [  ac_pthreads_library="$withval"
    ])

if test "$ac_pthreads_includes" = NO || test "$ac_pthreads_library" = NO; then

dnl AC_CACHE_VAL(ac_cv_have_pthreads,
dnl [#try to guess pthreads locations

pthreads_incdirs="$ac_pthreads_includes /usr/include /usr/local/include
 /usr/local/pthreads /usr/local/libpthreads \
 $HOME/pthreads $HOME/libpthreads \
 ${topdir}/pthreads \
 /usr/include/gr $PTHREADS_INC"
test -n "$PTHREADSDIR" && pthreads_incdirs="$PTHREADSDIR/include $PTHREADSDIR $pthreads_incdirs"
AC_FIND_FILE(pthread.h, $pthreads_incdirs, pthreads_incdir)
ac_pthreads_includes=$pthreads_incdir

if test "$ac_pthreads_library" = NO; then

pthreads_libdirs="$ac_pthreads_libraries /lib /usr/lib /usr/local/lib
 /usr/local/pthreads /usr/local/libpthreads \
 $HOME/pthreads $HOME/libpthreads \
 ${topdir}/pthreads ${topdir}/libpthreads \
 $PTHREADSLIB"
test -n "$PTHREADSDIR" && pthreads_libdirs="$PTHREADSDIR/lib $PTHREADSDIR $pthreads_libdirs"
AC_FIND_FILE(libpthreads.so libpthreads.so.1 libpthreads.a libpthread.so libpthread.so.0 libpthread.a libpthreads.sl, $pthreads_libdirs, pthreads_libdir)

ac_pthreads_libraries=$pthreads_libdir

ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS

CXXFLAGS="$CXXFLAGS -I$pthreads_incdir -D_MIT_POSIX_THREADS -D_REENTRANT"
LDFLAGS="-L$pthreads_libdir"
LIBS="$LIBS -lpthreads -lm"

AC_LANG_CPLUSPLUS
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include "pthread.h"
int main() {
  pthread_t t;
  pthread_create(&t,0,0,0);
  return 0;
}
EOF

LIBNAME=""
ADDIT_CFLAGS=""

if test "$ac_pthreads_libraries" = "/usr/lib" || \
   test "$ac_pthreads_libraries" = "/lib"     || \
   test "$ac_pthreads_libraries" = "/usr/local/lib" || \
   test -z "$ac_pthreads_libraries"; then
  tmp_lib_path=""
else
  tmp_lib_path="-L$ac_pthreads_libraries"
fi

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
  LIBNAME="pthreads"
  ADDIT_CFLAGS="-D_MIT_POSIX_THREADS -D_REENTRANT"
  if test -z "$tmp_lib_path" ; then
    ac_pthreads_library="-lpthreads"
  else
    ac_pthreads_library="$tmp_lib_path -lpthreads"
  fi
else
  CXXFLAGS="$ac_cxxflags_safe -I$pthreads_incdir -D_REENTRANT"
  # Now check for glibc pthread library
  LIBS="$ac_libs_safe -lpthread -lm"
  AC_LANG_CPLUSPLUS
  if AC_TRY_EVAL(ac_link) && test -s conftest; then
    rm -f conftest*
    LIBNAME="pthread"
    ADDIT_CFLAGS="-D_REENTRANT"
    if test -z "$tmp_lib_path" ; then
      ac_pthreads_library="-lpthread"
    else
      ac_pthreads_library="$tmp_lib_path -lpthread"
    fi
  else
    echo "configure: failed program was:" >&AC_FD_CC
    cat conftest.$ac_ext >&AC_FD_CC
    ac_pthreads_libraries="NO"
  fi
fi
rm -f conftest*
CXXFLAGS=$ac_cxxflags_safe
LDFLAGS=$ac_ldflags_safe
LIBS=$ac_libs_safe

# end if library == NO
fi

if test "$ac_pthreads_includes" = NO || test "$ac_pthreads_library" = NO; then
  ac_cv_have_pthreads="have_pthreads=no"
  ac_pthreads_notfound=""
  if test "$ac_pthreads_includes" = NO; then
    if test "$ac_pthreads_library" = NO; then
      ac_pthreads_notfound="(headers and library)";
    else
      ac_pthreads_notfound="(headers)";
    fi
  else
    ac_pthreads_notfound="(library)";
  fi

  have_pthreads="no"
else
  have_pthreads="yes"
fi
dnl ])
else
 have_pthreads="yes"
fi

eval "$ac_cv_have_pthreads"

HAS_PTHREADS=$have_pthreads

if test "$have_pthreads" != yes; then
  AC_MSG_RESULT([$have_pthreads]);
  AC_MSG_WARN([libpthreads $ac_pthreads_notfound not found. PTHREADS support disabled.]);

  ac_pthreads_includes=""
  ac_pthreads_library=""
else
  ac_cv_have_pthreads="have_pthreads=yes \
    ac_pthreads_includes=$ac_pthreads_includes ac_pthreads_library=$ac_pthreads_library"
  AC_MSG_RESULT([library $ac_pthreads_library, headers $ac_pthreads_includes])

  pthreads_library=$ac_pthreads_library
  pthreads_includes=$ac_pthreads_includes
fi

AC_SUBST(pthreads_library)
AC_SUBST(pthreads_libraries)
AC_SUBST(pthreads_includes)

if test "$pthreads_includes" = "/usr/include" || \
   test "$pthreads_includes" = "/usr/local/include" || \
   test -z "$pthreads_includes"; then
 PTHREADS_INCLUDES="";
else
 PTHREADS_INCLUDES="-I$pthreads_includes"
 all_includes="$PTHREADS_INCLUDES $all_includes"
fi

if test "$pthreads_libraries" = "/usr/lib" || \
   test "$pthreads_libraries" = "/lib"     || \
   test "$pthreads_libraries" = "/usr/local/lib" || \
   test -z "$pthreads_libraries"; then
 PTHREADS_LDFLAGS=""
else
 PTHREADS_LDFLAGS="-L$pthreads_libraries"
# all_libraries="$PTHREADS_LDFLAGS $all_libraries"
 all_libraries="$ac_pthreads_library $all_libraries"
fi

PTHREADS_LIBNAME=$LIBNAME
PTHREADS_LIBRARY=$ac_pthreads_library

PTHREADS_CFLAGS="$ADDIT_CFLAGS"

AC_SUBST(PTHREADS_LIBNAME)
AC_SUBST(HAS_PTHREADS)
AC_SUBST(PTHREADS_INCLUDES)
AC_SUBST(PTHREADS_CFLAGS)
AC_SUBST(PTHREADS_LIBRARY)
AC_SUBST(PTHREADS_LDFLAGS)
])

## ------------------------------------------------------------------------
## Check for libtool
## ------------------------------------------------------------------------
##
dnl just a wrapper to clean up configure.in
AC_DEFUN(MOONLIGHT_PROG_LIBTOOL,
[
dnl libtool is only for C, so I must force him
dnl to find the correct flags for C++

ac_save_cc=$CC
ac_save_cflags=$CFLAGS
CC=$CXX
CFLAGS=$CXXFLAGS
AM_PROG_LIBTOOL dnl for libraries
CC=$ac_save_cc
CFLAGS=$ac_save_cflags
])

## ------------------------------------------------------------------------
## Check for dynamic loading of shared libraries
## ------------------------------------------------------------------------
##
AC_DEFUN(MOONLIGHT_CHECK_DLOPEN,
[
AC_CHECK_LIB(dl, dlopen, [
LIBDL="-ldl"
ac_cv_have_dlfcn=yes
])

AC_CHECK_LIB(dld, shl_unload, [
LIBDL="-ldld"
ac_cv_have_shload=yes
])

AC_SUBST(LIBDL)
AC_CHECK_HEADERS(dlfcn.h dl.h)
if test "$ac_cv_header_dlfcn_h" = "no"; then
  ac_cv_have_dlfcn=no
fi

if test "$ac_cv_header_dl_h" = "no"; then
  ac_cv_have_shload=no
fi

#AC_ARG_ENABLE(dlopen,
#[  --disable-dlopen        link staticly [default=no]] ,
#[if test "$enableval" = yes; then
#  enable_dlopen=yes
#else
#  enable_dlopen=no
#fi],
#enable_dlopen=yes)

enable_dlopen=yes

# override the user's opinion, if we know it better ;)
if test "$ac_cv_have_dlfcn" = "no" && test "$ac_cv_have_shload" = "no"; then
  enable_dlopen=no
fi

if test "$ac_cv_have_dlfcn" = "yes"; then
  AC_DEFINE_UNQUOTED(HAVE_DLFCN)
fi

if test "$ac_cv_have_shload" = "yes"; then
  AC_DEFINE_UNQUOTED(HAVE_SHLOAD)
fi

if test "$enable_dlopen" = no ; then
  $1
else
  $2
fi

])

AC_DEFUN(MOONLIGHT_CHECK_DYNAMIC_LOADING,
[
MOONLIGHT_CHECK_DLOPEN(libtool_enable_shared=no, libtool_enable_static=no)
MOONLIGHT_PROG_LIBTOOL
AC_MSG_CHECKING([dynamic loading])
eval "`egrep '^build_libtool_libs=' libtool`"
if test "$build_libtool_libs" = "yes" && test "$enable_dlopen" = "yes"; then
  dynamic_loading=yes
  AC_DEFINE_UNQUOTED(HAVE_DYNAMIC_LOADING)
else
  dynamic_loading=no
fi
AC_MSG_RESULT($dynamic_loading)

#if test "$dynamic_loading" = "yes"; then
#  $1
#else
#  $2
#fi
])

